
CREATE TABLE black_softname_type_ref_vague (
                                               software_name varchar(160) DEFAULT NULL,
                                               software_type varchar(160) DEFAULT NULL
)$;
CREATE INDEX idx_BLACK_SOFTNAME_TYPE_REF_VAGUE_SN_ST ON black_softname_type_ref_vague (software_type,software_type)$;

CREATE TABLE softname_type_ref (
                                   software_name varchar(160) DEFAULT NULL,
                                   software_type varchar(160) DEFAULT NULL
)$;
CREATE INDEX idx_SOFTNAME_TYPE_REF_SN_ST ON softname_type_ref (software_type,software_type)$;


CREATE TABLE softname_type_ref_vague (
                                         software_name varchar(160) DEFAULT NULL,
                                         software_type varchar(160) DEFAULT NULL,
                                         isdelect varchar(255) DEFAULT '0'
)$;
CREATE INDEX idx_SOFTNAME_TYPE_REF_VAGUE_SN_ST ON softname_type_ref_vague (software_type,software_type)$;


CREATE TABLE type_process_ref (
                                  software_type varchar(160) DEFAULT NULL,
                                  process_name varchar(160) DEFAULT NULL,
                                  iseffect varchar(255) DEFAULT '1',
                                  level varchar(255) DEFAULT '4'
)$;
CREATE INDEX idx_TYPE_PROCESS_REF_PN ON type_process_ref (process_name)$;
CREATE INDEX idx_TYPE_PROCESS_REF_ST ON type_process_ref (software_type)$;
CREATE INDEX idx_lower_software_type ON "type_process_ref" (LOWER(software_type));
CREATE INDEX idx_level_desc ON "type_process_ref" (level DESC);


CREATE TABLE soft_cate_ref (
                               software_type varchar(255) DEFAULT NULL,
                               cid int DEFAULT null
)$;

CREATE INDEX uk_soft_type_cid ON soft_cate_ref (software_type, cid)$;




CREATE TABLE soft_classification (
                                     id serial PRIMARY KEY,
                                     pid int DEFAULT NULL,
                                     name varchar(40) DEFAULT NULL,
                                     name_tw varchar(40) DEFAULT NULL,
                                     name_en varchar(40) DEFAULT NULL,
                                     icon varchar(60) DEFAULT NULL,
                                     "desc" varchar(600) DEFAULT ''
)$;




INSERT INTO soft_classification (id, pid, name, name_tw, name_en, icon, "desc") VALUES(1, '0', '__focus__','__focus__','__focus__', 'soft-cate-24', ''),
                                                                                      (2, '0', '__noclassification__','__noclassification__','__noclassification__', 'soft-cate-24', ''),
                                                                                    (16, '0', '办公软件', '辦公軟體', 'Office File', 'fa-th-large', ''),
                                                                                    (17, '0', '图形图像设计', '圖形影像設計', 'Photo & Media Design', 'fa-th-large', ''),
                                                                                    (18, '0', '二维工程设计', '二維工程設計', 'Engineering Design', 'fa-th-large', ''),
                                                                                    (19, '0', '三维工程设计', '三維工程設計', 'TD-Engineering Design', 'fa-th-large', ''),
                                                                                    (20, '0', '电子电路设计', '電子電路設計', 'Electronics Design', 'fa-th-large', ''),
                                                                                    (21, '0', '文字处理', '文書處理', 'Text Editor', 'fa-th-large', ''),
                                                                                    (22, '0', '编程开发', '編程開發', 'Programming', 'fa-th-large', ''),
                                                                                    (23, '0', '多媒体软件', '多媒體軟體', 'Multimedia Software', 'fa-th-large', ''),
                                                                                    (24, '0', '管理软件', '管理軟體', 'ERP System', 'fa-th-large', ''),
                                                                                    (25, '0', '教育教学软件', '教育教學軟體', 'Educational Software', 'fa-th-large', ''),
                                                                                    (26, '0', '统计分析', '統計分析', 'Statistical Analysis', 'fa-th-large', ''),
                                                                                    (27, '0', '光学分析', '光學分析', 'Optical Analysis', 'fa-th-large', ''),
                                                                                    (28, '0', 'CAE软件', 'CAE軟體', 'CAE Software', 'fa-th-large', ''),
                                                                                    (33, '0', '版权软件', '版權軟體', 'Copyright Software', 'soft-cate-1', '')$;

-- ocular3_analyze.software definition

CREATE TABLE software (
                          software_type varchar(160) PRIMARY KEY,
                          "desc" varchar(600) DEFAULT '',
                          soft_auth_num int DEFAULT '0',
                          manufacturer varchar(160) DEFAULT '',
                          generate_process varchar(255) DEFAULT '0',
                          id serial NOT NULL
)$;
CREATE INDEX idx_SOFTNAME_TYPE_SN_ST ON software (software_type)$;
CREATE INDEX idx_id ON software (id)$;

CREATE TABLE app_report_log (
                                appDate varchar(160) PRIMARY KEY,
                                id serial NOT NULL,
                                syncNum int DEFAULT '0'
)$;
CREATE INDEX idx_APP_REPORT_DATE ON app_report_log (appDate)$;
CREATE INDEX idx_APP_REPORT_id ON app_report_log (id)$;

CREATE TABLE doclog_sync_log (
                                 appDate varchar(160) PRIMARY KEY,
                                 docLogId int,
                                 decryptLogId int,
                                 update_time  timestamp default CURRENT_TIMESTAMP
)$;


INSERT INTO black_softname_type_ref_vague VALUES ('*File Validation Add-In*', 'Microsoft Office')$;
INSERT INTO black_softname_type_ref_vague VALUES ('*Launcher*', 'Python')$;
INSERT INTO black_softname_type_ref_vague VALUES ('*Licensing Installer*', 'MasterCAM')$;
INSERT INTO black_softname_type_ref_vague VALUES ('*MUI*', 'Microsoft Office')$;
INSERT INTO black_softname_type_ref_vague VALUES ('*SDK*', 'Microsoft Visual Studio')$;
INSERT INTO black_softname_type_ref_vague VALUES ('*Service Pack*', 'Microsoft Office')$;
INSERT INTO black_softname_type_ref_vague VALUES ('*Tool*', 'Microsoft Visual Studio')$;
INSERT INTO black_softname_type_ref_vague VALUES ('*Tool*', 'Python')$;
INSERT INTO black_softname_type_ref_vague VALUES ('*Web Components*', 'Microsoft Office')$;
INSERT INTO black_softname_type_ref_vague VALUES ('*WPS图片*', 'WPS')$;
INSERT INTO black_softname_type_ref_vague VALUES ('*XML SDK*', 'Microsoft Office')$;
INSERT INTO black_softname_type_ref_vague VALUES ('*加载项*', 'Microsoft Office')$;
INSERT INTO black_softname_type_ref_vague VALUES ('*工具提示语言*', 'Microsoft Office')$;
INSERT INTO black_softname_type_ref_vague VALUES ('Adobe Acrobat Reader*', 'Adobe Acrobat')$;
INSERT INTO black_softname_type_ref_vague VALUES ('OriginPro*', 'Origin')$;


INSERT INTO softname_type_ref_vague VALUES ('WPS Office*', 'WPS', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('*福昕阅读器*', '福昕阅读器', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('*Foxit Reader*', '福昕阅读器', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('OpenOffice*', 'OpenOffice', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('*极速PDF阅读器*', '极速PDF阅读器', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('Adobe Photoshop*', 'Adobe Photoshop', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('Autodesk 3ds Max*', 'Autodesk 3ds Max', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('Microsoft 画图*', 'Microsoft 画图', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('KeyShot*', 'KeyShot', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('PTC Creo View ECAD*', 'PTC ProE/Creo', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('*中望CAD*', '中望CAD', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('ZWCAD*', '中望CAD', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('Autodesk DWG TrueView*', 'Autodesk DWG TrueView', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('*浩辰CAD*', '浩辰CAD', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('记事本', 'Microsoft 记事本', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('写字板', 'Microsoft 写字板', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('EditPlus*', 'EditPlus', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('WinMerge*', 'WinMerge', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('Sublime Text*', 'Sublime Text', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('Autodesk Inventor*', 'Autodesk Inventor', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('MasterCAM*', 'MasterCAM', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('Solidworks PDM*', 'Solidworks PDM', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('Solidworks * PDM', 'Solidworks PDM', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('*Visual C++ 6.0*', 'Microsoft Visual Studio', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('Eclipse*', 'Eclipse', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('Matlab*', 'Matlab', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('Araxis Merge*', 'Araxis Merge', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('Source Insight*', 'Source Insight', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('IntelliJ IDEA*', 'IntelliJ IDEA', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('*Delphi*', 'Delphi', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('Beyond Compare*', 'Beyond Compare', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('CodeBlocks*', 'CodeBlocks', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('Android Studio*', 'Android Studio', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('*Visual Studio Code*', 'Microsoft Visual Studio', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('*pycharm*', 'pycharm', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('Cmake*', 'Cmake', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('暴风影音*', '暴风影音', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('Windows Media Player*', 'Windows Media Player', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('QQ影音*', 'QQ影音', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('iStylePDF*', 'iStylePDF', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('MyEclipse*', 'MyEclipse', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('Adobe Bridge*', 'Adobe Bridge', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('*Moldflow*', 'Autodesk Moldflow', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('*Automation License Manager*', 'Automation License Manager', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('Axure RP*', 'Axure RP', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('*CADdoctor*', 'CADdoctor', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('*CAJViewer*', 'CAJViewer', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('*ChemDraw*', 'ChemDraw', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('*Choice金融终端*', 'Choice金融终端', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('*Corel VideoStudio*', 'Corel VideoStudio', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('DataBridge*', 'DataBridge', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('Endnote*', 'Endnote', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('EPLAN*', 'EPLAN', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('*ForceControl*', 'ForceControl', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('GX Works*', 'GX Works', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('GX Works2*', 'GX Works', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('*Insight*', 'Source Insight', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('*IR SearchMaster*', 'IR SearchMaster', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('*KEPServer*', 'KEPServer', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('*KiSSsoft*', 'KiSSsoft', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('Lenovo Auto Scroll Utility*', 'Lenovo Auto Scroll Utility', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('Mathtype*', 'Mathtype', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('Minitab*', 'Minitab', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('*Navicat*', 'Navicat', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('OMNIC*', 'OMNIC', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('OMNIC Specta*', 'OMNIC', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('*Power BI Desktop*', 'Power BI Desktop', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('*Revit*', 'Revit', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('Simatic Wincc*', 'Simatic Wincc', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('*Tekla Structures*', 'Tekla Structures', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('*Visual Studio Community*', 'Microsoft Visual Studio', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('V-Ray*', 'V-Ray', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('*WinCC*', 'Simatic Wincc', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('SketchUp $ver$', 'Google SketchUp', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('光影魔术手*', '光影魔术手', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('迅捷PDF转换器*', '迅捷PDF转换器', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('Microsoft Visio $ver$', 'Microsoft Visio', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('Microsoft Visio Premium $ver$', 'Microsoft Visio', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('WPS', 'WPS', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('CATIA Composer $ver$', 'CATIA Composer', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('迅捷PDF转换器', '迅捷PDF转换器', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('暴风影音', '暴风影音', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('Paragon HFS+ for Windows $ver$', 'Paragon HFS+ for Windows', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('美图看看', '美图看看', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('Microsoft Visio', 'Microsoft Visio', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('福昕PDF阅读器 $ver$', '福昕阅读器', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('office $ver$', 'Microsoft Office', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('Microsoft Visio 專業 $ver$', 'Microsoft Visio', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('Adobe After Effects $ver$', 'Adobe After Effects', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('Everything', 'Everything', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('Adobe Audition*', 'Adobe Audition', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('Adobe Acrobat*', 'Adobe Acrobat', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('Adobe Reader $ver$', 'Adobe Reader', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('Microsoft Visual Studio $ver$', 'Microsoft Visual Studio', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('Autodesk AutoCAD $ver$', 'Autodesk AutoCAD', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('Microsoft Office $ver$', 'Microsoft Office', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('Solidworks $ver$', 'Solidworks', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('Everything $ver$', 'Everything', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('Origin $ver$', 'Origin', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('Mindjet MindManager $ver$', 'Mindjet MindManager', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('MindManager $ver$', 'Mindjet MindManager', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('Xmind $ver$', 'Xmind', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('Altium Designer*', 'Altium Designer', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('CorelDRAW *', 'CorelDRAW', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('Photoshop*', 'Adobe Photoshop', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('Adobe Illustrator $ver$', 'Adobe Illustrator', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('BarTender $ver$', 'BarTender', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('MestReNova $ver$', 'MestReNova', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('美图看看 $ver$', '美图看看', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('看图纸 $ver$', '看图纸(CADSee Plus)', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('ABAQUS*', 'ABAQUS', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('Notepad++', 'Notepad++', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('Notepad++ $ver', 'Notepad++', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('Typora $ver$', 'Typora', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('UltraEdit', 'UltraEdit', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('UltraEdit $ver$', 'UltraEdit', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('Adobe Dreamweaver $ver$', 'Adobe Dreamweaver', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('Python $ver$', 'Python', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('Qt $ver$', 'Qt Creator', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('Serial Port Utility $ver$', 'Serial Port Utility', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('UltraISO Premium $ver$', 'UltraISO Premium', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('VSPlayer $ver$', 'VSPlayer', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('VSPlayer', 'VSPlayer', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('QT Lite $ver$', 'Qt Creator', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('Adobe Premiere $ver$', 'Adobe Premiere', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('Microsoft 365*', 'Microsoft 365', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('WPS $ver$', 'WPS', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('PyCharm $ver$', 'PyCharm', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('福昕阅读器', '福昕阅读器', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('中望CAD $ver$', '中望CAD', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('Minitab $ver$', 'Minitab', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('OMNIC $ver$', 'OMNIC', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('Notepad++ $ver$', 'Notepad++', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('极速PDF阅读器 $ver$', '极速PDF阅读器', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('CorelDRAW $ver$', 'CorelDRAW', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('EPLAN $ver$', 'EPLAN', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('光影魔术手', '光影魔术手', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('极速PDF阅读器', '极速PDF阅读器', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('CADdoctor $ver$', 'CADdoctor', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('Abaqus $ver$', 'Abaqus', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('浩辰CAD $ver$', '浩辰CAD', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('EditPlus', 'EditPlus', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('Navicat $ver$', 'Navicat', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('EndNote $ver$', 'EndNote', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('MathType $ver$', 'MathType', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('MATLAB $ver$', 'MATLAB', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('OMNIC', 'OMNIC', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('福昕阅读器 $ver$', '福昕阅读器', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('MyEclipse $ver$', 'MyEclipse', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('iStylePDF $ver$', 'iStylePDF', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('Revit $ver$', 'Revit', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('Mastercam $ver$', 'Mastercam', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('CAJViewer $ver$', 'CAJViewer', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('暴风影音 $ver$', '暴风影音', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('光影魔术手 $ver$', '光影魔术手', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('EditPlus $ver$', 'EditPlus', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('迅捷PDF转换器 $ver$', '迅捷PDF转换器', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('OpenOffice $ver$', 'OpenOffice', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('DataBridge', 'DataBridge', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('Choice金融终端', 'Choice金融终端', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('WinMerge $ver$', 'WinMerge', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('V-Ray $ver$', 'V-Ray', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('KISSsoft $ver$', 'KISSsoft', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('KeyShot $ver$', 'KeyShot', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('CodeBlocks', 'CodeBlocks', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('Eclipse $ver$', 'Eclipse', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('CMake', 'CMake', '0')$;
INSERT INTO softname_type_ref_vague VALUES ('Xmind', 'Xmind', '0')$;



INSERT INTO software VALUES ('Adobe Reader', '', '0', '', '1', '124')$;
INSERT INTO software VALUES ('Altium Designer', '', '0', '', '1', '125')$;
INSERT INTO software VALUES ('Automation License Manager', '', '0', '', '1', '126')$;
INSERT INTO software VALUES ('CADdoctor', '', '0', '', '1', '127')$;
INSERT INTO software VALUES ('CAJViewer', '', '0', '', '1', '128')$;
INSERT INTO software VALUES ('ChemDraw', '', '0', '', '1', '129')$;
INSERT INTO software VALUES ('Choice金融终端', '', '0', '', '1', '130')$;
INSERT INTO software VALUES ('Corel VideoStudio', '', '0', '', '1', '131')$;
INSERT INTO software VALUES ('CorelDRAW', '', '0', '', '1', '132')$;
INSERT INTO software VALUES ('Delphi', '', '0', '', '1', '133')$;
INSERT INTO software VALUES ('Adobe Dreamweaver', '', '0', '', '1', '134')$;
INSERT INTO software VALUES ('ForceControl', '', '0', '', '1', '135')$;
INSERT INTO software VALUES ('福昕阅读器', '', '0', '', '1', '136')$;
INSERT INTO software VALUES ('Source Insight', '', '0', '', '1', '137')$;
INSERT INTO software VALUES ('IR SearchMaster', '', '0', '', '1', '138')$;
INSERT INTO software VALUES ('KEPServer', '', '0', '', '1', '139')$;
INSERT INTO software VALUES ('KiSSsoft', '', '0', '', '1', '140')$;
INSERT INTO software VALUES ('Mindjet MindManager', '', '0', '', '1', '141')$;
INSERT INTO software VALUES ('Autodesk Moldflow', '', '0', '', '1', '142')$;
INSERT INTO software VALUES ('Navicat', '', '0', '', '1', '143')$;
INSERT INTO software VALUES ('Power BI Desktop', '', '0', '', '1', '144')$;
INSERT INTO software VALUES ('pycharm', '', '0', '', '1', '145')$;
INSERT INTO software VALUES ('Revit', '', '0', '', '1', '146')$;
INSERT INTO software VALUES ('Tekla Structures', '', '0', '', '1', '147')$;
INSERT INTO software VALUES ('Microsoft Visual Studio', '', '0', '', '1', '148')$;
INSERT INTO software VALUES ('Simatic Wincc', '', '0', '', '1', '149')$;
INSERT INTO software VALUES ('中望CAD', '', '0', '', '1', '150')$;
INSERT INTO software VALUES ('极速PDF阅读器', '', '0', '', '1', '151')$;
INSERT INTO software VALUES ('浩辰CAD', '', '0', '', '1', '152')$;
INSERT INTO software VALUES ('Adobe After Effects', '', '0', '', '1', '153')$;
INSERT INTO software VALUES ('Adobe Bridge', '', '0', '', '1', '154')$;
INSERT INTO software VALUES ('Adobe Illustrator', '', '0', '', '1', '156')$;
INSERT INTO software VALUES ('Adobe Premiere', '', '0', '', '1', '157')$;
INSERT INTO software VALUES ('Android Studio', '', '0', '', '1', '158')$;
INSERT INTO software VALUES ('Araxis Merge', '', '0', '', '1', '159')$;
INSERT INTO software VALUES ('Autodesk AutoCAD', '', '0', '', '1', '160')$;
INSERT INTO software VALUES ('Autodesk 3ds Max', '', '0', '', '1', '161')$;
INSERT INTO software VALUES ('Autodesk DWG TrueView', '', '0', '', '1', '162')$;
INSERT INTO software VALUES ('Autodesk Inventor', '', '0', '', '1', '163')$;
INSERT INTO software VALUES ('Axure RP', '', '0', '', '1', '164')$;
INSERT INTO software VALUES ('BarTender', '', '0', '', '1', '165')$;
INSERT INTO software VALUES ('Beyond Compare', '', '0', '', '1', '166')$;
INSERT INTO software VALUES ('Cmake', '', '0', '', '1', '167')$;
INSERT INTO software VALUES ('CodeBlocks', '', '0', '', '1', '168')$;
INSERT INTO software VALUES ('DataBridge', '', '0', '', '1', '169')$;
INSERT INTO software VALUES ('Eclipse', '', '0', '', '1', '170')$;
INSERT INTO software VALUES ('EditPlus', '', '0', '', '1', '171')$;
INSERT INTO software VALUES ('Endnote', '', '0', '', '1', '172')$;
INSERT INTO software VALUES ('EPLAN', '', '0', '', '1', '173')$;
INSERT INTO software VALUES ('Everything', '', '0', '', '1', '174')$;
INSERT INTO software VALUES ('GX Works', '', '0', '', '1', '175')$;
INSERT INTO software VALUES ('IntelliJ IDEA', '', '0', '', '1', '176')$;
INSERT INTO software VALUES ('iStylePDF', '', '0', '', '1', '177')$;
INSERT INTO software VALUES ('KeyShot', '', '0', '', '1', '178')$;
INSERT INTO software VALUES ('Lenovo Auto Scroll Utility', '', '0', '', '1', '179')$;
INSERT INTO software VALUES ('MasterCAM', '', '0', '', '1', '180')$;
INSERT INTO software VALUES ('Mathtype', '', '0', '', '1', '181')$;
INSERT INTO software VALUES ('Matlab', '', '0', '', '1', '182')$;
INSERT INTO software VALUES ('MestReNova', '', '0', '', '1', '183')$;
    INSERT INTO software VALUES ('`Microsoft 画图`', '', '0', '', '1', '185')$;
INSERT INTO software VALUES ('Minitab', '', '0', '', '1', '186')$;
INSERT INTO software VALUES ('MyEclipse', '', '0', '', '1', '187')$;
INSERT INTO software VALUES ('Notepad++', '', '0', '', '1', '188')$;
INSERT INTO software VALUES ('OMNIC', '', '0', '', '1', '189')$;
INSERT INTO software VALUES ('OpenOffice', '', '0', '', '1', '190')$;
INSERT INTO software VALUES ('Origin', '', '0', '', '1', '191')$;
INSERT INTO software VALUES ('PTC ProE/Creo', '', '0', '', '1', '192')$;
INSERT INTO software VALUES ('Python', '', '0', '', '1', '193')$;
INSERT INTO software VALUES ('QQ影音', '', '0', '', '1', '194')$;
INSERT INTO software VALUES ('Qt Creator', '', '0', '', '1', '195')$;
INSERT INTO software VALUES ('Serial Port Utility', '', '0', '', '1', '196')$;
INSERT INTO software VALUES ('Google SketchUp', '', '0', '', '1', '197')$;
INSERT INTO software VALUES ('Solidworks PDM', '', '0', '', '1', '198')$;
INSERT INTO software VALUES ('Solidworks', '', '0', '', '1', '199')$;
INSERT INTO software VALUES ('Sublime Text', '', '0', '', '1', '200')$;
INSERT INTO software VALUES ('Typora', '', '0', '', '1', '201')$;
INSERT INTO software VALUES ('UltraEdit', '', '0', '', '1', '202')$;
INSERT INTO software VALUES ('UltraISO Premium', '', '0', '', '1', '203')$;
INSERT INTO software VALUES ('V-Ray', '', '0', '', '1', '204')$;
INSERT INTO software VALUES ('VSPlayer', '', '0', '', '1', '205')$;
INSERT INTO software VALUES ('Windows Media Player', '', '0', '', '1', '206')$;
INSERT INTO software VALUES ('WinMerge', '', '0', '', '1', '207')$;
INSERT INTO software VALUES ('WPS', '', '0', '', '1', '208')$;
INSERT INTO software VALUES ('Xmind', '', '0', '', '1', '209')$;
INSERT INTO software VALUES ('光影魔术手', '', '0', '', '1', '210')$;
INSERT INTO software VALUES ('Microsoft 写字板', '', '0', '', '1', '211')$;
INSERT INTO software VALUES ('暴风影音', '', '0', '', '1', '212')$;
INSERT INTO software VALUES ('看图纸(CADSee Plus)', '', '0', '', '1', '213')$;
INSERT INTO software VALUES ('美图看看', '', '0', '', '1', '214')$;
INSERT INTO software VALUES ('Microsoft 记事本', '', '0', '', '1', '215')$;
INSERT INTO software VALUES ('迅捷PDF转换器', '', '0', '', '1', '216')$;
INSERT INTO software VALUES ('Microsoft Visio', '', '0', '', '1', '458')$;
INSERT INTO software VALUES ('Microsoft Office', '', '0', '', '1', '184')$;
INSERT INTO software VALUES ('Adobe Acrobat', '', '0', '', '1', '220')$;
INSERT INTO software VALUES ('ABAQUS', '', '0', '', '1', '8434')$;
INSERT INTO software VALUES ('CATIA Composer', '', '0', '', '1', '8435')$;
INSERT INTO software VALUES ('Adobe Audition', '', '0', '', '1', '366')$;
INSERT INTO software VALUES ('Adobe Photoshop', '', '0', '', '1', '155')$;
INSERT INTO software VALUES ('Microsoft 365', '', '0', '', '1', '5152')$;



INSERT INTO soft_cate_ref VALUES ('WPS', '16')$;
INSERT INTO soft_cate_ref VALUES ('福昕阅读器', '16')$;
INSERT INTO soft_cate_ref VALUES ('OpenOffice', '16')$;
INSERT INTO soft_cate_ref VALUES ('Mindjet MindManager', '16')$;
INSERT INTO soft_cate_ref VALUES ('极速PDF阅读器', '16')$;
INSERT INTO soft_cate_ref VALUES ('Xmind', '16')$;
INSERT INTO soft_cate_ref VALUES ('Adobe Illustrator', '17')$;
INSERT INTO soft_cate_ref VALUES ('Autodesk 3ds Max', '17')$;
INSERT INTO soft_cate_ref VALUES ('Microsoft 画图', '17')$;
INSERT INTO soft_cate_ref VALUES ('KeyShot', '17')$;
INSERT INTO soft_cate_ref VALUES ('美图看看', '17')$;
INSERT INTO soft_cate_ref VALUES ('Autodesk AutoCAD', '18')$;
INSERT INTO soft_cate_ref VALUES ('PTC ProE/Creo', '19')$;
INSERT INTO soft_cate_ref VALUES ('中望CAD', '18')$;
INSERT INTO soft_cate_ref VALUES ('Autodesk DWG TrueView', '18')$;
INSERT INTO soft_cate_ref VALUES ('浩辰CAD', '18')$;
INSERT INTO soft_cate_ref VALUES ('Altium Designer', '1')$;
INSERT INTO soft_cate_ref VALUES ('Microsoft 记事本', '21')$;
INSERT INTO soft_cate_ref VALUES ('Microsoft 写字板', '21')$;
INSERT INTO soft_cate_ref VALUES ('Notepad++', '21')$;
INSERT INTO soft_cate_ref VALUES ('UltraEdit', '21')$;
INSERT INTO soft_cate_ref VALUES ('EditPlus', '21')$;
INSERT INTO soft_cate_ref VALUES ('WinMerge', '21')$;
INSERT INTO soft_cate_ref VALUES ('Sublime Text', '21')$;
INSERT INTO soft_cate_ref VALUES ('Typora', '21')$;
INSERT INTO soft_cate_ref VALUES ('Autodesk Inventor', '19')$;
INSERT INTO soft_cate_ref VALUES ('Solidworks', '19')$;
INSERT INTO soft_cate_ref VALUES ('MasterCAM', '19')$;
INSERT INTO soft_cate_ref VALUES ('Google SketchUp', '19')$;
INSERT INTO soft_cate_ref VALUES ('Solidworks PDM', '19')$;
INSERT INTO soft_cate_ref VALUES ('Microsoft Visual Studio', '1')$;
INSERT INTO soft_cate_ref VALUES ('Eclipse', '22')$;
INSERT INTO soft_cate_ref VALUES ('Matlab', '22')$;
INSERT INTO soft_cate_ref VALUES ('Araxis Merge', '22')$;
INSERT INTO soft_cate_ref VALUES ('Source Insight', '22')$;
INSERT INTO soft_cate_ref VALUES ('Adobe Dreamweaver', '22')$;
INSERT INTO soft_cate_ref VALUES ('IntelliJ IDEA', '22')$;
INSERT INTO soft_cate_ref VALUES ('Delphi', '22')$;
INSERT INTO soft_cate_ref VALUES ('Beyond Compare', '22')$;
INSERT INTO soft_cate_ref VALUES ('Qt Creator', '22')$;
INSERT INTO soft_cate_ref VALUES ('CodeBlocks', '22')$;
INSERT INTO soft_cate_ref VALUES ('Android Studio', '22')$;
INSERT INTO soft_cate_ref VALUES ('Python', '22')$;
INSERT INTO soft_cate_ref VALUES ('pycharm', '22')$;
INSERT INTO soft_cate_ref VALUES ('Cmake', '22')$;
INSERT INTO soft_cate_ref VALUES ('暴风影音', '23')$;
INSERT INTO soft_cate_ref VALUES ('Windows Media Player', '23')$;
INSERT INTO soft_cate_ref VALUES ('QQ影音', '23')$;
INSERT INTO soft_cate_ref VALUES ('iStylePDF', '16')$;
INSERT INTO soft_cate_ref VALUES ('MyEclipse', '22')$;
INSERT INTO soft_cate_ref VALUES ('Adobe After Effects', '17')$;
INSERT INTO soft_cate_ref VALUES ('Adobe Bridge', '17')$;
INSERT INTO soft_cate_ref VALUES ('Adobe Premiere', '17')$;
INSERT INTO soft_cate_ref VALUES ('Adobe Reader', '1')$;
INSERT INTO soft_cate_ref VALUES ('Autodesk Moldflow', '19')$;
INSERT INTO soft_cate_ref VALUES ('Automation License Manager', '24')$;
INSERT INTO soft_cate_ref VALUES ('Axure RP', '18')$;
INSERT INTO soft_cate_ref VALUES ('BarTender', '17')$;
INSERT INTO soft_cate_ref VALUES ('CADdoctor', '19')$;
INSERT INTO soft_cate_ref VALUES ('CAJViewer', '16')$;
INSERT INTO soft_cate_ref VALUES ('ChemDraw', '25')$;
INSERT INTO soft_cate_ref VALUES ('Choice金融终端', '26')$;
INSERT INTO soft_cate_ref VALUES ('Corel VideoStudio', '17')$;
INSERT INTO soft_cate_ref VALUES ('CorelDRAW', '17')$;
INSERT INTO soft_cate_ref VALUES ('DataBridge', '24')$;
INSERT INTO soft_cate_ref VALUES ('Endnote', '16')$;
INSERT INTO soft_cate_ref VALUES ('EPLAN', '19')$;
INSERT INTO soft_cate_ref VALUES ('Everything', '16')$;
INSERT INTO soft_cate_ref VALUES ('ForceControl', '22')$;
INSERT INTO soft_cate_ref VALUES ('GX Works', '22')$;
INSERT INTO soft_cate_ref VALUES ('IR SearchMaster', '27')$;
INSERT INTO soft_cate_ref VALUES ('KEPServer', '22')$;
INSERT INTO soft_cate_ref VALUES ('KiSSsoft', '28')$;
INSERT INTO soft_cate_ref VALUES ('Lenovo Auto Scroll Utility', '23')$;
INSERT INTO soft_cate_ref VALUES ('Mathtype', '16')$;
INSERT INTO soft_cate_ref VALUES ('MestReNova', '17')$;
INSERT INTO soft_cate_ref VALUES ('Minitab', '26')$;
INSERT INTO soft_cate_ref VALUES ('Navicat', '22')$;
INSERT INTO soft_cate_ref VALUES ('OMNIC', '27')$;
INSERT INTO soft_cate_ref VALUES ('Origin', '16')$;
INSERT INTO soft_cate_ref VALUES ('Power BI Desktop', '24')$;
INSERT INTO soft_cate_ref VALUES ('Revit', '19')$;
INSERT INTO soft_cate_ref VALUES ('Serial Port Utility', '22')$;
INSERT INTO soft_cate_ref VALUES ('Simatic Wincc', '22')$;
INSERT INTO soft_cate_ref VALUES ('Tekla Structures', '19')$;
INSERT INTO soft_cate_ref VALUES ('UltraISO Premium', '23')$;
INSERT INTO soft_cate_ref VALUES ('V-Ray', '19')$;
INSERT INTO soft_cate_ref VALUES ('VSPlayer', '23')$;
INSERT INTO soft_cate_ref VALUES ('光影魔术手', '17')$;
INSERT INTO soft_cate_ref VALUES ('看图纸(CADSee Plus)', '18')$;
INSERT INTO soft_cate_ref VALUES ('迅捷PDF转换器', '16')$;
INSERT INTO soft_cate_ref VALUES ('Microsoft Office', '1')$;
INSERT INTO soft_cate_ref VALUES ('Adobe Photoshop', '1')$;
INSERT INTO soft_cate_ref VALUES ('Autodesk AutoCAD', '1')$;
INSERT INTO soft_cate_ref VALUES ('PTC ProE/Creo', '1')$;
INSERT INTO soft_cate_ref VALUES ('中望CAD', '1')$;
INSERT INTO soft_cate_ref VALUES ('Altium Designer', '20')$;
INSERT INTO soft_cate_ref VALUES ('Solidworks', '1')$;
INSERT INTO soft_cate_ref VALUES ('Microsoft Visual Studio', '22')$;
INSERT INTO soft_cate_ref VALUES ('IntelliJ IDEA', '1')$;
INSERT INTO soft_cate_ref VALUES ('MyEclipse', '1')$;
INSERT INTO soft_cate_ref VALUES ('Adobe Reader', '16')$;
INSERT INTO soft_cate_ref VALUES ('CorelDRAW', '1')$;
INSERT INTO soft_cate_ref VALUES ('Microsoft Visio', '33')$;
INSERT INTO soft_cate_ref VALUES ('Adobe Audition', '33')$;
INSERT INTO soft_cate_ref VALUES ('Microsoft Office', '16')$;
INSERT INTO soft_cate_ref VALUES ('ABAQUS', '19')$;
INSERT INTO soft_cate_ref VALUES ('CATIA Composer', '19')$;
INSERT INTO soft_cate_ref VALUES ('Adobe Photoshop', '17')$;
INSERT INTO soft_cate_ref VALUES ('Microsoft 365', '33')$;
INSERT INTO soft_cate_ref VALUES ('Adobe Acrobat', '21')$;



INSERT INTO type_process_ref VALUES ('WPS', 'wpsoffice.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('WPS', 'wps.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('WPS', 'photolaunch.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('WPS', 'DocumentRepair.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('WPS', 'JSOCR.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('WPS', 'et.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('WPS', 'WinWPP.EXE', '1', '4')$;
INSERT INTO type_process_ref VALUES ('WPS', 'wpp.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('WPS', 'aeoplayer.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('福昕阅读器', 'FoxitReader.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('福昕阅读器', 'FoxitPhantom.EXE', '1', '4')$;
INSERT INTO type_process_ref VALUES ('福昕阅读器', 'Foxit Reader.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('福昕阅读器', 'FoxitPhantomPDF.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('OpenOffice', 'sbase.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('OpenOffice', 'scalc.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('OpenOffice', 'sdraw.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('OpenOffice', 'simpress.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('OpenOffice', 'swriter.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('OpenOffice', 'sweb.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('OpenOffice', 'soffice.bin', '1', '4')$;
INSERT INTO type_process_ref VALUES ('OpenOffice', 'smath.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('极速PDF阅读器', 'JisuPdf.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('极速PDF阅读器', 'JisuWorkCommon.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('iStylePDF', 'iStylePDF.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('中望CAD', 'ZWCAD.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Autodesk DWG TrueView', 'dwgviewr.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('浩辰CAD', 'GcLauncher.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('浩辰CAD', 'IWebProxy.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('浩辰CAD', 'gcad.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('浩辰CAD', 'icad.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Autodesk Inventor', 'InventorViewCompute.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Autodesk Inventor', 'AcWebBrowser.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Autodesk Inventor', 'DBXBridge.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Autodesk Inventor', 'Inventor.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Autodesk Inventor', 'InventorView.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('PTC ProE/Creo', 'proe.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('PTC ProE/Creo', 'xtop.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('PTC ProE/Creo', 'pro_dwgconv.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('PTC ProE/Creo', 'productview.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('PTC ProE/Creo', 'illustrate.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('PTC ProE/Creo', 'prod_dcu.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('PTC ProE/Creo', 'creoagent.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('MasterCAM', 'lathe9.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('MasterCAM', 'CIMCOEdit.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('MasterCAM', 'MILL9.EXE', '1', '4')$;
INSERT INTO type_process_ref VALUES ('MasterCAM', 'Mastercam.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Google SketchUp', 'SketchUp.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Solidworks PDM', 'ItemExplorer.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Solidworks PDM', 'FileViewer.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Solidworks PDM', 'ConisioAdmin.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Adobe Photoshop', 'Photoshop.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Adobe Illustrator', 'Illustrator.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Autodesk 3ds Max', '3dsmax.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Autodesk 3ds Max', 'aruba.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Microsoft 画图', 'MSPAINT.EXE.MUI', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Microsoft 画图', 'MSPAINT.EXE', '1', '4')$;
INSERT INTO type_process_ref VALUES ('KeyShot', 'keyshot_daemon.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('KeyShot', 'keyshot.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('美图看看', 'KanKanST.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Microsoft Visual Studio', 'devenv.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Eclipse', 'javaw.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Eclipse', 'eclipse.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Matlab', 'MATLAB.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Araxis Merge', 'Merge.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Source Insight', 'Insight3.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Source Insight', 'sourceinsight4.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Adobe Dreamweaver', 'Dreamweaver.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('IntelliJ IDEA', 'idea.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('IntelliJ IDEA', 'idea64.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Delphi', 'delphi32.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('MyEclipse', 'javaw.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('MyEclipse', 'myeclipse.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Beyond Compare', 'BCompare.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Beyond Compare', 'BC2.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('CodeBlocks', 'codeblocks.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('CodeBlocks', 'cb_console_runner.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Android Studio', 'studio64.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('pycharm', 'pythonw.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('pycharm', 'pycharm64.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Cmake', 'cmake-gui.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Microsoft 记事本', 'NOTEPAD.EXE', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Microsoft 记事本', 'NOTEPAD.EXE.MUI', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Microsoft 写字板', 'WORDPAD.EXE.MUI', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Microsoft 写字板', 'WORDPAD.EXE', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Microsoft 写字板', 'wordpad', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Notepad++', 'notepad++.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('WinMerge', 'WinMergeU.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Sublime Text', 'sublime_text.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Typora', 'Typora.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('暴风影音', 'StormPlayer9.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('暴风影音', 'Storm.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Windows Media Player', 'wmplayer.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('QQ影音', 'QQPlayer.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('EditPlus', 'editplus.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Adobe Bridge', 'Bridge.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Adobe Premiere', 'Adobe Premiere Pro.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Adobe Reader', 'AcroRd32Info.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Adobe Reader', 'AcroRd32.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Autodesk Moldflow', 'synergy.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Autodesk Moldflow', 'mfresview.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Autodesk Moldflow', 'acwebbrowser.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Autodesk Moldflow', 'synmesh.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Automation License Manager', 'almsrv64x.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Automation License Manager', 'almapp64x.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Automation License Manager', 'almsrvx.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Automation License Manager', 'almappx.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Automation License Manager', 'almsrvbubblex.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Automation License Manager', 'almsrvbubble64x.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Automation License Manager', 'CCMCPAUTSERVER.EXE', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Automation License Manager', 'compatibilitycheck.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Axure RP', 'AxureRP8.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Axure RP', 'Axure RP.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Axure RP', 'AxureRP.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Axure RP', 'AxureRPPorable.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Axure RP', 'AxureRP9.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('BarTender', 'bartend.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('CADdoctor', 'CADdoctor.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('CAJViewer', 'CAJViewer.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('CAJViewer', 'CAJVieweru.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('CAJViewer', 'CAJViewer(Cloud).exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('ChemDraw', 'ChemDraw.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Choice金融终端', 'EmStart.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Corel VideoStudio', 'vstudio.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('CorelDRAW', 'CorelDrw.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('DataBridge', 'DataBridge.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('DataBridge', 'DataBridgeDataManager.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Endnote', 'EndNote.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Endnote', 'EndNotechs.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('EPLAN', 'Eplan.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('EPLAN', 'EplanCommonA.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('EPLAN', 'ElmMonitor.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('EPLAN', 'ElmHostId.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Everything', 'Everything.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('ForceControl', 'Forcecontrol.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('GX Works', 'GX Works2 Progress.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('GX Works', 'GD2.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('GX Works', 'PMConfigv2.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('GX Works', 'GXW3.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('GX Works', 'GD.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Source Insight', 'lassoinsights.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('IR SearchMaster', 'IRSearchMaster.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('KiSSsoft', 'KISSsoftCOM.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('KiSSsoft', 'KISSsoft32.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Lenovo Auto Scroll Utility', 'AutoScroll-gfvv33ew.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Mathtype', 'MathType.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Mathtype', 'MTW6.0b.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('MestReNova', 'MestReNova.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Minitab', 'Mtb.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Navicat', 'navicat.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('OMNIC', 'omnic_mc.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('OMNIC', 'Picta.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('OMNIC', 'EZOMNC32.EXE', '1', '4')$;
INSERT INTO type_process_ref VALUES ('OMNIC', 'omnic32.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('OMNIC', 'OpenOmnicFiles.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('OMNIC', 'OmnicSpecta.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Power BI Desktop', 'PBIDesktop.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Power BI Desktop', 'Egw-prod.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Revit', 'RCLOENU.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Revit', 'REX.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Revit', 'RCLCRVT.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Revit', 'RevitWorker.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Revit', 'RCLEDEU.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Revit', 'RCLEENU.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Serial Port Utility', 'serial_port_utility_latest.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Simatic Wincc', 'HmiSRTClassic.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Simatic Wincc', 'CcUaDAS.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Simatic Wincc', 'HMISRT.EXE', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Simatic Wincc', 'CCOpcUaImporter.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Simatic Wincc', 'TOUCHINPUTPC.EXE', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Tekla Structures', 'TeklaStructures.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Tekla Structures', 'EnvironmentManager.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('UltraISO Premium', 'UltraISO.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('V-Ray', 'vray.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('VSPlayer', 'VSPlayer.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Simatic Wincc', 'RedundancyState.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Simatic Wincc', 'CCONLCMP.EXE', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Simatic Wincc', 'RedundancyControl.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Simatic Wincc', 'WEBNAVIGATORRT.EXE', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Simatic Wincc', 'CCAEPROVIDER.EXE', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Simatic Wincc', 'CCREDCODI.EXE', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Simatic Wincc', 'SmartClient.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Simatic Wincc', 'StartCenter.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Simatic Wincc', 'AutoStartRT.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Simatic Wincc', 'HmiES.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Simatic Wincc', 'TransferTool.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('ABAQUS', 'eliT_dslsTargetID.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('ABAQUS', 'eliT_dslsStat.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('ABAQUS', 'eliT_DriverLM.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('ABAQUS', 'composersync.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('ABAQUS', 'composerplayer.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('ABAQUS', 'composer.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('ABAQUS', 'CNEXT.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('ABAQUS', 'ABQvwrK.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('ABAQUS', 'ABQvwrG.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('ABAQUS', 'ABQsysconf.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('ABAQUS', 'ABQcaeK.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('ABAQUS', 'ABQcaeG.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('ABAQUS', 'abaqus.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Python', 'python.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('UltraEdit', 'uedit32.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('UltraEdit', 'uedit64.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('光影魔术手', 'nEOiMAGING4.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('光影魔术手', 'nEOiMAGING.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('看图纸(CADSee Plus)', 'CADSee.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('迅捷PDF转换器', 'pdfconverter.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('KEPServer', 'KEPServerEx5.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Adobe Acrobat', 'Acrobat.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Adobe Audition', 'Adobe Audition.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Adobe Audition', 'GPUSniffer.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Microsoft 365', 'EXCEL.EXE', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Microsoft 365', 'ONENOTE.EXE', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Microsoft 365', 'OUTLOOK.EXE', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Adobe After Effects', 'AEGPUSniffer.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Microsoft 365', 'WINWORD.EXE', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Microsoft 365', 'POWERPNT.EXE', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Autodesk AutoCAD', 'AcWebBrowser.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Minitab', 'SoftwareManager.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Minitab', 'MtbGE.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Microsoft Office', 'WINPROJ.EXE', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Microsoft Office', 'VPREVIEW.EXE', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Microsoft Office', 'VISIO.EXE', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Microsoft Office', 'MSACCESS.EXE', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Microsoft Office', 'WINWORD.EXE', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Microsoft Office', 'EXCEL.EXE', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Microsoft Office', 'PowerPnt.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Microsoft Office', 'msoia.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Microsoft Office', 'MSOHTMED.EXE', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Microsoft Office', 'MsoSync.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Microsoft Office', 'BCSSync.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Microsoft Office', 'msohelp.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Microsoft Office', 'MSOUC.EXE', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Microsoft Office', 'lync.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Microsoft Office', 'MSPUB.EXE', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Microsoft Office', 'OIS.EXE', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Microsoft Office', 'GROOVEMN.EXE', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Microsoft Office', 'excelcnv.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Microsoft Office', 'MSOSREC.EXE', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Microsoft Office', 'SDXHelper.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Microsoft Office', 'PDFREFLOW.EXE', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Microsoft Office', 'Wordconv.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Microsoft Office', 'lynchtmlconv.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Solidworks', 'sldworks.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Solidworks', 'swvbaserver.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Microsoft Visual Studio', 'BackgroundDownload.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Autodesk AutoCAD', 'acad.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Autodesk AutoCAD', 'AcBrowserHost.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Autodesk AutoCAD', 'senddmp.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Autodesk AutoCAD', 'AdExchange.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Autodesk AutoCAD', 'admigrator.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Autodesk AutoCAD', 'AcSettingSync.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Mindjet MindManager', 'MindMan.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Mindjet MindManager', 'MmReminderService.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Xmind', 'XMind.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('ABAQUS', 'ABAQUSLM.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('ABAQUS', 'eliT_SiteID.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('ABAQUS', 'lmcryptABAQUSLM.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('ABAQUS', 'SMAAbuPathSet.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Adobe After Effects', 'GPUSniffer.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Adobe Acrobat', 'AcrobatInfo.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Adobe Acrobat', 'acrobat_sl.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Adobe Acrobat', 'acrodist.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Adobe Acrobat', 'ADNotificationManager.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Adobe Acrobat', 'reader_sl.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Adobe Acrobat', 'Acrobat Elements.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Adobe Acrobat', 'Acrobat.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Adobe Acrobat', 'Acrobat_sl.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Adobe Acrobat', 'AcroBroker.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Adobe Acrobat', 'AcroDist.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Adobe Acrobat', 'AcroRd32.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Adobe Acrobat', 'ADNotificationManager.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Adobe Acrobat', 'adobe_licutil.exe', '1', '4')$;
INSERT INTO type_process_ref VALUES ('Adobe Acrobat', 'WCChromeNativeMessagingHost.exe', '1', '4')$;


CREATE TABLE syncRecord  (
                             id int PRIMARY KEY,
                             softInstallId int,
                             appInstallId int,
                             userId  int,
                             userGroupId  int,
                             agentId  int,
                             agentGroupId  int,
                             appReportId  int,
                             lastRecordTime TIMESTAMP,
                             maxSourceLevel int,
                             initGenerate int,
                             initTime   varchar(6)
)$;

insert into syncRecord values(0,0,0,0,0,0,0,0,now(),0,0,to_char(now(),'YYYYMM'))$;

-- create view
CREATE VIEW softname_type_ref_view AS
SELECT
    CONCAT(software_name,'#', software_type) AS id,
    t.*
FROM
    softname_type_ref t$;


CREATE VIEW type_process_ref_view AS
SELECT
    CONCAT(software_type,'#', process_name) AS id,
    t.*
FROM
    type_process_ref t
where iseffect = '1'$;


CREATE VIEW softname_type_ref_vague_view AS
SELECT
    CONCAT(software_name,'#', software_type) AS id,
    t.*
FROM
    softname_type_ref_vague t$;


CREATE VIEW black_softname_type_ref_vague_view AS
SELECT
    CONCAT(software_name,'#', software_type) AS id,
    t.*
FROM
    black_softname_type_ref_vague t$;

CREATE VIEW soft_cate_ref_view AS
SELECT
    CONCAT(software_type,'#', cid) AS id,
    t.*
FROM
    soft_cate_ref t$;

-- oanalyze.warn_rule definition

CREATE TABLE warn_rule (
                           rule_id serial PRIMARY KEY,
                           name varchar(160) NOT NULL,
                           describe varchar(255) DEFAULT NULL,
                           status int DEFAULT NULL,
                           opr_type int DEFAULT NULL,
                           user_acts varchar(255) DEFAULT NULL,
                           period varchar(20) DEFAULT NULL,
                           update_time TIMESTAMP DEFAULT NULL,
                           rev_email varchar(255) DEFAULT NULL,
                           file_class_ids varchar(255) DEFAULT NULL,
                           obj_names      varchar(20480) default null
)$;

-- oanalyze.warn_rule_info definition

CREATE TABLE warn_rule_info (
                                wri_id serial PRIMARY KEY,
                                rule_id int NOT NULL,
                                level int DEFAULT NULL,
                                file_count int DEFAULT NULL,
                                relation int DEFAULT NULL,
                                file_size int DEFAULT NULL,
                                unit int DEFAULT NULL,
                                score int DEFAULT NULL,
                                file_size_byte bigint null
)$;
CREATE INDEX IDX_WARN_RULE_INFO_RULEID ON warn_rule_info (rule_id)$;

-- auto-generated definition
create table warn_obj
(
    warn_obj_id serial primary key,
    rule_id     int null,
    obj_type    int null,
    obj_id      varchar(100) null
)$;

-- auto-generated definition
create table sys_conf
(
    config_id serial
        primary key,
    type      integer,
    value     varchar(2048),
    act       integer,
    name      varchar(50),
    constraint uk_sys_conf_type unique(type)
)$;

INSERT INTO sys_conf (config_id, type, value, act, name) VALUES (1, 1, '1', null, null)$;
INSERT INTO sys_conf (config_id, type, value, act, name) VALUES (2, 2, '60', null, null)$;
INSERT INTO sys_conf (config_id, type, value, act, name) VALUES (3, 7, '{"Account":"","Password":"","Port":0,"Server":""}', null, null)$;
INSERT INTO sys_conf (config_id, type, value, act, name) VALUES (4, 4, '', 1, null)$;
INSERT INTO sys_conf (config_id, type, value, act, name) VALUES (5, 5, 'rtx.exe,feiq.exe', 1, null)$;
INSERT INTO sys_conf (config_id, type, value, act, name) VALUES (6, 6, '*127.0.0.1*,*localhost*', 1, null)$;
INSERT INTO sys_conf (config_id, type, value, act, name) VALUES (10000, 8, '[{"filterType":1211,"compare":1,"value":"9"},{"filterType":1213,"compare":1,"value":"wxwork.exe"},{"filterType":1313,"compare":1,"value":"企业微信截图_*"}]', 1, '企业微信缓存')$;
INSERT INTO sys_conf (config_id, type, value, act, name) VALUES (1000, 1000, '', null, 'outgoing_view')$;

CREATE TABLE syncTableConfig(
                                id int PRIMARY KEY,
                                tblName varchar(100),
                                fieldSql varchar(5000),
                                whereSql varchar(5000),
                                tblType  varchar(6),
                                syncDays varchar(6),
                                clearDays  varchar(6),
                                status  varchar(6),
                                errMessage	varchar(2000)
)$;

CREATE TABLE genTableConfig(
                               id int PRIMARY KEY,
                               tblName varchar(100),
                               genSql varchar(4000),
                               partitionCol	varchar(100),
                               queryField	varchar(1000),
                               showField	varchar(1000),
                               tableDesc	varchar(1000)
)$;

CREATE TABLE common_sync_log (
                                 id	serial PRIMARY KEY,
                                 tblId	int,
                                 appDate varchar(160) NOT NULL,
                                 maxId int,
                                 constraint uk_common_sync_log_id unique(tblId,appDate)
)$;

create table filter_config
(
    fc_id       serial primary key,
    user_name   varchar(50),
    fc_name     varchar(50),
    page_id     integer,
    create_time timestamp,
    value       varchar(8192)
)$;



create table send_type
(
    st_id       serial
        primary key,
    st_name     varchar(50),
    st_name_tw     varchar(1000),
    st_name_en     varchar(1000),
    status      integer,
    update_time timestamp,
    value       varchar(20480),
    add_type    integer,
    restore_id  integer,
    is_default  boolean,
    level       integer
)$;

INSERT INTO send_type (st_id, st_name, st_name_tw,st_name_en, status, update_time, value, add_type, restore_id, is_default, level) VALUES (-1003, '复制到移动盘', '複製到移動儲存','Copy to mobile disk',1, null, '{"is_leaf":false,"relation":1,"next":[{"is_leaf":true,"relation":0,"next":[],"data":{"filterType":1211,"compare":1,"value":"2,3","value2":"","unit":0,"unit2":0}},{"is_leaf":true,"relation":0,"next":[],"data":{"filterType":1322,"compare":1,"value":"4","value2":"","unit":0,"unit2":0}},{"is_leaf":true,"relation":0,"next":[],"data":{"filterType":1318,"compare":2,"value":"4","value2":"","unit":0,"unit2":0}}]}', 1, 0, false, 300)$;
INSERT INTO send_type (st_id, st_name, st_name_tw,st_name_en, status, update_time, value, add_type, restore_id, is_default, level) VALUES (-100000, '其他', '其他', 'Other',1, null, '', 1, -100000, true, 1000000)$;
INSERT INTO send_type (st_id, st_name, st_name_tw,st_name_en, status, update_time, value, add_type, restore_id, is_default, level) VALUES (-1001, 'IM传送', 'IM傳送','Instant messaging',1, null, '{"is_leaf":false,"relation":1,"next":[{"is_leaf":true,"relation":0,"next":[],"data":{"filterType":1211,"compare":1,"value":"9","value2":"","unit":0,"unit2":0}},{"is_leaf":true,"relation":0,"next":[],"data":{"filterType":1213,"compare":1,"value":"qq.exe,icq.exe,mideaconnecthanyu.exe,zalo.exe,tm.exe,wxdrive.exe,wxworkweb.exe,wemail.exe,wemailnode.exe,dingtalk,qq,whatsapp.exe,skype.exe,sametime.exe,connect.exe,alitalk.exe,aliim.exe,fetion.exe,263em.exe,officeim.exe,cloudhub.exe,im9.exe,nlnotes,qqcrm.exe,amsger.exe,qqeim.exe,qidian.exe,line.exe,cc.exe,communicator.exe,lync.exe,wechat.exe,kk5.0.exe,kk6.1.exe,imoclient.exe,dingtalk.exe,wxwork.exe,企业微信,tim.exe,aliworkbench.exe,lxmain.exe,feishu.exe,lark.exe","value2":"","unit":0,"unit2":0}}]}', 1, 0, false, 100)$;
INSERT INTO send_type (st_id, st_name, st_name_tw,st_name_en, status, update_time, value, add_type, restore_id, is_default, level) VALUES (1001, 'IM传送', 'IM傳送','Instant messaging',1, null, '{"is_leaf":false,"relation":1,"next":[{"is_leaf":true,"relation":0,"next":[],"data":{"filterType":1211,"compare":1,"value":"9","value2":"","unit":0,"unit2":0}},{"is_leaf":true,"relation":0,"next":[],"data":{"filterType":1213,"compare":1,"value":"qq.exe,icq.exe,mideaconnecthanyu.exe,zalo.exe,tm.exe,wxdrive.exe,wxworkweb.exe,wemail.exe,wemailnode.exe,dingtalk,qq,whatsapp.exe,skype.exe,sametime.exe,connect.exe,alitalk.exe,aliim.exe,fetion.exe,263em.exe,officeim.exe,cloudhub.exe,im9.exe,nlnotes,qqcrm.exe,amsger.exe,qqeim.exe,qidian.exe,line.exe,cc.exe,communicator.exe,lync.exe,wechat.exe,kk5.0.exe,kk6.1.exe,imoclient.exe,dingtalk.exe,wxwork.exe,企业微信,tim.exe,aliworkbench.exe,lxmain.exe,feishu.exe,lark.exe","value2":"","unit":0,"unit2":0}}]}', 1, -1001, false, 100)$;
INSERT INTO send_type (st_id, st_name, st_name_tw,st_name_en, status, update_time, value, add_type, restore_id, is_default, level) VALUES (1003, '复制到移动盘', '複製到移動儲存','Copy to mobile disk',1, null, '{"is_leaf":false,"relation":1,"next":[{"is_leaf":true,"relation":0,"next":[],"data":{"filterType":1211,"compare":1,"value":"2,3","value2":"","unit":0,"unit2":0}},{"is_leaf":true,"relation":0,"next":[],"data":{"filterType":1322,"compare":1,"value":"4","value2":"","unit":0,"unit2":0}},{"is_leaf":true,"relation":0,"next":[],"data":{"filterType":1318,"compare":2,"value":"4","value2":"","unit":0,"unit2":0}}]}', 1, -1003, false, 300)$;
INSERT INTO send_type (st_id, st_name, st_name_tw,st_name_en, status, update_time, value, add_type, restore_id, is_default, level) VALUES (1002, '复制到网络盘', '複製到網路碟','Copy to network disk',1, null, '{"is_leaf":false,"next":[{"is_leaf":true,"data":{"compare":1,"filterType":1211,"value":"2,3"}},{"is_leaf":true,"data":{"compare":2,"filterType":1318,"value":"5"}},{"is_leaf":true,"data":{"compare":1,"filterType":1322,"value":"5"}}],"relation":1}', 1, -1002, false, 200)$;
INSERT INTO send_type (st_id, st_name, st_name_tw,st_name_en, status, update_time, value, add_type, restore_id, is_default, level) VALUES (-1007, '浏览器上传', '瀏覽器上傳','Browser upload',1, null, '{"is_leaf":false,"relation":1,"next":[{"is_leaf":true,"relation":0,"next":[],"data":{"filterType":1211,"compare":1,"value":"9","value2":"","unit":0,"unit2":0}},{"is_leaf":true,"relation":0,"next":[],"data":{"filterType":1213,"compare":1,"value":"360chromex.exe,chromecore.exe,2345explorer.exe,chrome.exe,msedge.exe,microsoftedge.exe,liebao.exe,theworld.exe,qqbrowser.exe,sogouexplorer.exe,firefox.exe,360se.exe,360chrome.exe,iexplore.exe,opera.exe,launcher.exe,ucbrowser.exe","value2":"","unit":0,"unit2":0}}]}', 1, 0, false, 700)$;
INSERT INTO send_type (st_id, st_name, st_name_tw,st_name_en, status, update_time, value, add_type, restore_id, is_default, level) VALUES (-1002, '复制到网络盘', '複製到網路碟','Copy to network disk',1, null, '{"is_leaf":false,"next":[{"is_leaf":true,"data":{"compare":1,"filterType":1211,"value":"2,3"}},{"is_leaf":true,"data":{"compare":2,"filterType":1318,"value":"5"}},{"is_leaf":true,"data":{"compare":1,"filterType":1322,"value":"5"}}],"relation":1}', 1, 0, false, 200)$;
INSERT INTO send_type (st_id, st_name, st_name_tw,st_name_en, status, update_time, value, add_type, restore_id, is_default, level) VALUES (-1004, '网盘上传', '網盤上傳','Cloud disk upload',1, null, '{"is_leaf":false,"next":[{"is_leaf":true,"data":{"compare":1,"filterType":1211,"value":"9"}},{"is_leaf":true,"data":{"compare":1,"filterType":1213,"value":"baidunetdiskunite.exe,adrive.exe,huawei cloud.exe,123pan.exe,Weiyun.exe,AliyunPan.exe,iCloud.exe,HuaweiYunSpace.exe,quarkclouddrive.exe,WeiyunApp.exe,wydrive.exe,360EnterpriseDiskUI.exe,Dropbox.exe,OneDrive.exe,BaiduNetdisk.exe,DBank_ClickUp.exe,NutstoreClient.exe,SpeedPanX.exe,EnterpriseCloud.exe,eCloud.exe,WXDrive.exe,aDrive.exe"}},{"is_leaf":true,"data":{"compare":3,"filterType":1323,"value":"www.aliyun.com,cloud.huaiwei.com,www.123pan.com,www.weiyun.com,www.aliyundrive.com,www.icloud.com,pan.quark.cn,www.weiyun.com,yunpan.360.cn,pan.baidu.com,www.jianguoyun.com,cloud.189.cn,onedrive.live.com,www.dropbox.com,b.cloud.189.cn"}}],"relation":1}', 1, 0, false, 400)$;
INSERT INTO send_type (st_id, st_name, st_name_tw,st_name_en, status, update_time, value, add_type, restore_id, is_default, level) VALUES (1005, 'SVN/GIT上传', 'SVN/GIT上傳','SVN/GIT upload',1, null, '{"is_leaf":false,"next":[{"is_leaf":true,"data":{"compare":1,"filterType":1211,"value":"9"}},{"is_leaf":true,"data":{"compare":1,"filterType":1213,"value":"git.exe,TortoiseProc.exe"}}],"relation":1}', 1, -1005, false, 500)$;
INSERT INTO send_type (st_id, st_name, st_name_tw,st_name_en, status, update_time, value, add_type, restore_id, is_default, level) VALUES (-1005, 'SVN/GIT上传','SVN/GIT上傳','SVN/GIT upload', 1, null, '{"is_leaf":false,"next":[{"is_leaf":true,"data":{"compare":1,"filterType":1211,"value":"9"}},{"is_leaf":true,"data":{"compare":1,"filterType":1213,"value":"git.exe,TortoiseProc.exe"}}],"relation":1}', 1, 0, false, 500)$;
INSERT INTO send_type (st_id, st_name, st_name_tw,st_name_en, status, update_time, value, add_type, restore_id, is_default, level) VALUES (-1006, 'FTP上传','FTP上傳','FTP upload', 1, null, '{"is_leaf":false,"next":[{"is_leaf":true,"data":{"compare":1,"filterType":1211,"value":"9"}},{"is_leaf":true,"data":{"compare":1,"filterType":1213,"value":"filezilla.exe,Serv-U.exe,FlashFXP.exe,cuteftp.exe,javaw.exe,WinSCP.exe"}}],"relation":1}', 1, 0, false, 600)$;
INSERT INTO send_type (st_id, st_name, st_name_tw,st_name_en, status, update_time, value, add_type, restore_id, is_default, level) VALUES (1006, 'FTP上传','FTP上傳','FTP upload', 1, null, '{"is_leaf":false,"next":[{"is_leaf":true,"data":{"compare":1,"filterType":1211,"value":"9"}},{"is_leaf":true,"data":{"compare":1,"filterType":1213,"value":"filezilla.exe,Serv-U.exe,FlashFXP.exe,cuteftp.exe,javaw.exe,WinSCP.exe"}}],"relation":1}', 1, -1006, false, 600)$;
INSERT INTO send_type (st_id, st_name, st_name_tw,st_name_en, status, update_time, value, add_type, restore_id, is_default, level) VALUES (1007, '浏览器上传', '瀏覽器上傳','Browser upload',1, null, '{"is_leaf":false,"relation":1,"next":[{"is_leaf":true,"relation":0,"next":[],"data":{"filterType":1211,"compare":1,"value":"9","value2":"","unit":0,"unit2":0}},{"is_leaf":true,"relation":0,"next":[],"data":{"filterType":1213,"compare":1,"value":"360chromex.exe,chromecore.exe,2345explorer.exe,chrome.exe,msedge.exe,microsoftedge.exe,liebao.exe,theworld.exe,qqbrowser.exe,sogouexplorer.exe,firefox.exe,360se.exe,360chrome.exe,iexplore.exe,opera.exe,launcher.exe,ucbrowser.exe","value2":"","unit":0,"unit2":0}}]}', 1, -1007, false, 700)$;
INSERT INTO send_type (st_id, st_name, st_name_tw,st_name_en, status, update_time, value, add_type, restore_id, is_default, level) VALUES (1004, '网盘上传', '網盤上傳','Cloud disk upload',1, null, '{"is_leaf":false,"next":[{"is_leaf":true,"data":{"compare":1,"filterType":1211,"value":"9"}},{"is_leaf":true,"data":{"compare":1,"filterType":1213,"value":"baidunetdiskunite.exe,adrive.exe,huawei cloud.exe,123pan.exe,Weiyun.exe,AliyunPan.exe,iCloud.exe,HuaweiYunSpace.exe,quarkclouddrive.exe,WeiyunApp.exe,wydrive.exe,360EnterpriseDiskUI.exe,Dropbox.exe,OneDrive.exe,BaiduNetdisk.exe,DBank_ClickUp.exe,NutstoreClient.exe,SpeedPanX.exe,EnterpriseCloud.exe,eCloud.exe,WXDrive.exe,aDrive.exe"}},{"is_leaf":true,"data":{"compare":3,"filterType":1323,"value":"www.aliyun.com,cloud.huaiwei.com,www.123pan.com,www.weiyun.com,www.aliyundrive.com,www.icloud.com,pan.quark.cn,www.weiyun.com,yunpan.360.cn,pan.baidu.com,www.jianguoyun.com,cloud.189.cn,onedrive.live.com,www.dropbox.com,b.cloud.189.cn"}}],"relation":1}', 1, -1004, false, 400)$;


create table file_class
(
    class_id       serial
        primary key,
    class_name     varchar(100),
    class_name_tw     varchar(1000),
    class_name_en     varchar(1000),
    extend_content varchar(512),
    status         integer,
    enable_extend  integer,
    enable_size    integer,
    compare        integer,
    value          integer,
    unit           integer,
    value2         integer,
    unit2          integer,
    value_byte     bigint,
    value2_byte    bigint,
    is_default     boolean default false,
    add_type       integer,
    update_time    timestamp,
    restore_id     integer
)$;


INSERT INTO file_class (class_id, class_name, class_name_tw, class_name_en, extend_content, status, enable_extend, enable_size, compare, value, unit, value2, unit2, value_byte, value2_byte, is_default, add_type, update_time, restore_id) VALUES
    (9, '图像设计图纸', '影像設計圖紙', 'Image designs', '*.psd,*.pdd,*.psb,*.max,*.drf,*.chr,*.ai,*.ait', 1, 1, null, null, null, null, null, null, null, null, false, 1, null, -9)$;

INSERT INTO file_class (class_id, class_name, class_name_tw, class_name_en, extend_content, status, enable_extend, enable_size, compare, value, unit, value2, unit2, value_byte, value2_byte, is_default, add_type, update_time, restore_id) VALUES
    (-10000001, '其他', '其他', 'Others', '*', 1, 0, null, null, null, null, null, null, null, null, true, 1, null, -1000)$;

INSERT INTO file_class (class_id, class_name, class_name_tw, class_name_en, extend_content, status, enable_extend, enable_size, compare, value, unit, value2, unit2, value_byte, value2_byte, is_default, add_type, update_time, restore_id)  VALUES
    (3, '代码文件', '代碼檔案', 'Code files', '*.h,*.hh,*.hpp,*.hxx,*.cpp,*.cc,*.cxx,*.c,*.c++,*.cur,*.css,*.dll,*.dsp,*.dsw,*.opt,*.obj,*.clw,*.idl,*.inl,*.jar,*.js,*.json,*.sln,*.lib,*.node,*.rc,*.rc2,*.res,*.csproj,*.scss,*.sh,*.sln,*.so,*.vbs,*.vcxproj,*.vcproj,*.vue,*.xsd,*.a,*.i,*.ii,*.m,*.o,*.s,*.ss,*.cs,*.java,*.class,*.php,*.pm,*.py,*.py3,*.pyc,*.pyo,*.pyd,*.pyi,*.pyx,*.pyz,*.pywz,*.rpy,*.pyde,*.pyp,*.pyt,*.kt', 1, 1, null, null, null, null, null, null, null, null, false, 1, null, -3)$;

INSERT INTO file_class (class_id, class_name, class_name_tw, class_name_en, extend_content, status, enable_extend, enable_size, compare, value, unit, value2, unit2, value_byte, value2_byte, is_default, add_type, update_time, restore_id)  VALUES
    (2, '图片文件', '圖片檔案', 'Picture files', '*.bmp,*.gif,*.jpe,*.jpeg,*.jpg,*.png,*.svg,*.tif,*.tiff', 1, 1, null, null, null, null, null, null, null, null, false, 1, null, -2)$;

INSERT INTO file_class (class_id, class_name, class_name_tw, class_name_en, extend_content, status, enable_extend, enable_size, compare, value, unit, value2, unit2, value_byte, value2_byte, is_default, add_type, update_time, restore_id)  VALUES
    (4, '压缩文件', '壓縮檔案', 'Compressed files', '*.rar,*.zip,*.7z,*.cab,*.lzh,*.jar,*.gz', 1, 1, null, null, null, null, null, null, null, null, false, 1, null, -4)$;

INSERT INTO file_class (class_id, class_name, class_name_tw, class_name_en, extend_content, status, enable_extend, enable_size, compare, value, unit, value2, unit2, value_byte, value2_byte, is_default, add_type, update_time, restore_id)  VALUES
    (5, '可执行文件', '可執行檔案', 'Executable files', '*.exe,*.com,*.sys,*.dll,*.bat', 1, 1, null, null, null, null, null, null, null, null, false, 1, null, -5)$;

INSERT INTO file_class (class_id, class_name, class_name_tw, class_name_en, extend_content, status, enable_extend, enable_size, compare, value, unit, value2, unit2, value_byte, value2_byte, is_default, add_type, update_time, restore_id)  VALUES
    (1, '办公文件', '辦公檔案', 'Office documents', '*.doc,*.docx,*.docm,*.dotm,*.dotx,*.dot,*.xls,*.xlsx,*.xlsm,*.xlsb,*.xltx,*.xltm,*.xlt,*.xlam,*.xla,*.ppt,*.pptx,*.pptm,*.potx,*.potm,*.pot,*.ppsx,*.ppsm,*.pps,*.ppam,*.ppa,*.vsd,*.vsdx,*.vssx,*.vstx,*.vsdm,*.vssm,*.vstm,*.pdf,*.vdw,*.vss,*.vst,*.xps,*.wps,*.wpt,*.et,*.ett,*.dps,*.dpt,*.xmind,*.xmap,*.xmt,*.md,*.mm,*.mmap,*.mindnode,*.txt,*.rtf', 1, 1, null, null, null, null, null, null, null, null, false, 1, null, -1)$;

INSERT INTO file_class (class_id, class_name, class_name_tw, class_name_en, extend_content, status, enable_extend, enable_size, compare, value, unit, value2, unit2, value_byte, value2_byte, is_default, add_type, update_time, restore_id)  VALUES
    (7, '三维图纸文件', '三維圖紙檔案', '3D drawings', '*.sldprt,*.sldasm,*.slddrw,*.asm,*.dft,*.par,*.psm,*.pwd,*.prt,*.fem,*.sim,*.afm,*.udf,*.drw,*.frm,*.mfg,*.lay,*.sec,*.dgm,*.rep,*.mrk,*.int,*.CATProduct,*.stp,*.igs,*.iges,*.CATPart', 1, 1, null, null, null, null, null, null, null, null, false, 1, null, -7)$;

INSERT INTO file_class (class_id, class_name, class_name_tw, class_name_en, extend_content, status, enable_extend, enable_size, compare, value, unit, value2, unit2, value_byte, value2_byte, is_default, add_type, update_time, restore_id)  VALUES
    (8, '电子电路图纸', '電子電路圖紙', 'Electronic circuit diagrams', '*.exb,*.pcb,*.sch,*.prj', 1, 1, null, null, null, null, null, null, null, null, false, 1, null, -8)$;

INSERT INTO file_class (class_id, class_name, class_name_tw, class_name_en, extend_content, status, enable_extend, enable_size, compare, value, unit, value2, unit2, value_byte, value2_byte, is_default, add_type, update_time, restore_id) VALUES
    (-10000000, '无后缀文件', '無後綴檔案', 'Files without suffixes', '', 1, 0, null, null, null, null, null, null, null, null, true, 1, null, -1000)$;

INSERT INTO file_class (class_id, class_name, class_name_tw, class_name_en, extend_content, status, enable_extend, enable_size, compare, value, unit, value2, unit2, value_byte, value2_byte, is_default, add_type, update_time, restore_id) VALUES
    (6, '二维图纸文件', '二維圖紙檔案', '2D drawings', '*.dwg,*.dws,*.dxf,*.dwt,*.dwf,*.dwfx', 1, 1, null, null, null, null, null, null, null, null, false, 1, null, -6)$;

INSERT INTO file_class (class_id, class_name, class_name_tw, class_name_en, extend_content, status, enable_extend, enable_size, compare, value, unit, value2, unit2, value_byte, value2_byte, is_default, add_type, update_time, restore_id) VALUES
    (-9, '图像设计图纸', '影像設計圖紙', 'Image designs', '*.psd,*.pdd,*.psb,*.max,*.drf,*.chr,*.ai,*.ait', 1, 1, null, null, null, null, null, null, null, null, false, 1, null, 0)$;

INSERT INTO file_class (class_id, class_name, class_name_tw, class_name_en, extend_content, status, enable_extend, enable_size, compare, value, unit, value2, unit2, value_byte, value2_byte, is_default, add_type, update_time, restore_id) VALUES
    (-8, '电子电路图纸', '電子電路圖紙', 'Electronic circuit diagrams', '*.exb,*.pcb,*.sch,*.prj', 1, 1, null, null, null, null, null, null, null, null, false, 1, null, 0)$;

INSERT INTO file_class (class_id, class_name, class_name_tw, class_name_en, extend_content, status, enable_extend, enable_size, compare, value, unit, value2, unit2, value_byte, value2_byte, is_default, add_type, update_time, restore_id) VALUES
    (-7, '三维图纸文件', '三維圖紙檔案', '3D drawings', '*.sldprt,*.sldasm,*.slddrw,*.asm,*.dft,*.par,*.psm,*.pwd,*.prt,*.fem,*.sim,*.afm,*.udf,*.drw,*.frm,*.mfg,*.lay,*.sec,*.dgm,*.rep,*.mrk,*.int,*.CATProduct,*.stp,*.igs,*.iges,*.CATPart', 1, 1, null, null, null, null, null, null, null, null, false, 1, null, 0)$;

INSERT INTO file_class (class_id, class_name, class_name_tw, class_name_en, extend_content, status, enable_extend, enable_size, compare, value, unit, value2, unit2, value_byte, value2_byte, is_default, add_type, update_time, restore_id) VALUES
    (-6, '二维图纸文件', '二維圖紙檔案', '2D drawings', '*.dwg,*.dws,*.dxf,*.dwt,*.dwf,*.dwfx', 1, 1, null, null, null, null, null, null, null, null, false, 1, null, 0)$;

INSERT INTO file_class (class_id, class_name, class_name_tw, class_name_en, extend_content, status, enable_extend, enable_size, compare, value, unit, value2, unit2, value_byte, value2_byte, is_default, add_type, update_time, restore_id) VALUES
    (-5, '可执行文件', '可執行檔案', 'Executable files', '*.exe,*.com,*.sys,*.dll,*.bat', 1, 1, null, null, null, null, null, null, null, null, false, 1, null, 0)$;

INSERT INTO file_class (class_id, class_name, class_name_tw, class_name_en, extend_content, status, enable_extend, enable_size, compare, value, unit, value2, unit2, value_byte, value2_byte, is_default, add_type, update_time, restore_id) VALUES
    (-4, '压缩文件', '壓縮檔案', 'Compressed files', '*.rar,*.zip,*.7z,*.cab,*.lzh,*.jar,*.gz', 1, 1, null, null, null, null, null, null, null, null, false, 1, null, 0)$;

INSERT INTO file_class (class_id, class_name, class_name_tw, class_name_en, extend_content, status, enable_extend, enable_size, compare, value, unit, value2, unit2, value_byte, value2_byte, is_default, add_type, update_time, restore_id) VALUES
    (-3, '代码文件', '代碼檔案', 'Code files', '*.h,*.hh,*.hpp,*.hxx,*.cpp,*.cc,*.cxx,*.c,*.c++,*.cur,*.css,*.dll,*.dsp,*.dsw,*.opt,*.obj,*.clw,*.idl,*.inl,*.jar,*.js,*.json,*.sln,*.lib,*.node,*.rc,*.rc2,*.res,*.csproj,*.scss,*.sh,*.sln,*.so,*.vbs,*.vcxproj,*.vcproj,*.vue,*.xsd,*.a,*.i,*.ii,*.m,*.o,*.s,*.ss,*.cs,*.java,*.class,*.php,*.pm,*.py,*.py3,*.pyc,*.pyo,*.pyd,*.pyi,*.pyx,*.pyz,*.pywz,*.rpy,*.pyde,*.pyp,*.pyt,*.kt', 1, 1, null, null, null, null, null, null, null, null, false, 1, null, 0)$;

INSERT INTO file_class (class_id, class_name, class_name_tw, class_name_en, extend_content, status, enable_extend, enable_size, compare, value, unit, value2, unit2, value_byte, value2_byte, is_default, add_type, update_time, restore_id) VALUES
    (-2, '图片文件', '圖片檔案', 'Picture files', '*.bmp,*.gif,*.jpe,*.jpeg,*.jpg,*.png,*.svg,*.tif,*.tiff', 1, 1, null, null, null, null, null, null, null, null, false, 1, null, 0)$;

INSERT INTO file_class (class_id, class_name, class_name_tw, class_name_en, extend_content, status, enable_extend, enable_size, compare, value, unit, value2, unit2, value_byte, value2_byte, is_default, add_type, update_time, restore_id) VALUES
    (-1, '办公文件', '辦公檔案', 'Office documents', '*.doc,*.docx,*.docm,*.dotm,*.dotx,*.dot,*.xls,*.xlsx,*.xlsm,*.xlsb,*.xltx,*.xltm,*.xlt,*.xlam,*.xla,*.ppt,*.pptx,*.pptm,*.potx,*.potm,*.pot,*.ppsx,*.ppsm,*.pps,*.ppam,*.ppa,*.vsd,*.vsdx,*.vssx,*.vstx,*.vsdm,*.vssm,*.vstm,*.pdf,*.vdw,*.vss,*.vst,*.xps,*.wps,*.wpt,*.et,*.ett,*.dps,*.dpt,*.xmind,*.xmap,*.xmt,*.md,*.mm,*.mmap,*.mindnode,*.txt,*.rtf', 1, 1, null, null, null, null, null, null, null, null, false, 1, null, 0)$;



create view file_class_view
            (class_id, class_name, class_name_tw, class_name_en, extend_content, status, enable_extend, enable_size, compare, value, unit, value2,
             unit2, value_byte, value2_byte)
as
SELECT file_class.class_id,
       file_class.class_name,
       file_class.class_name_tw,
       file_class.class_name_en,
       file_class.extend_content,
       file_class.status,
       file_class.enable_extend,
       file_class.enable_size,
       file_class.compare,
       file_class.value,
       file_class.unit,
       file_class.value2,
       file_class.unit2,
       file_class.value_byte,
       file_class.value2_byte
FROM file_class
WHERE file_class.restore_id <> 0 $;

CREATE TABLE compress_suffix (
    suffix varchar(160) NOT NULL
)$;
insert into compress_suffix values('7z')$;
insert into compress_suffix values('rar')$;
insert into compress_suffix values('zip')$;
insert into compress_suffix values('tar')$;
insert into compress_suffix values('gz')$;
insert into compress_suffix values('bz2')$;
insert into compress_suffix values('lzma')$;
insert into compress_suffix values('xz')$;

create table trace_retain
(
    main_id     varchar(100)  primary key,
    count       int null
)$;

-- 分类等级表
CREATE TABLE sec_level_lib (
    id integer,
    level integer,
    name varchar(100)
)$;

-- 信息分类表
CREATE TABLE IF NOT EXISTS sci_infoclass_lib (
     id integer,
     sil_id varchar(100),
     sil_name varchar(100),
     sil_type integer,
     sec_id integer,
     sil_data text,
     PRIMARY KEY (id)
)$;

-- 标签表
CREATE TABLE IF NOT EXISTS label_lib (
     id integer,
     ll_type integer,
     ll_cls_id integer,
     ll_cls_pid integer,
     ll_value varchar(1000),
    ll_memo varchar(1000),
    PRIMARY KEY (id)
)$;



Insert into syncTableConfig values(2,'asset_change_log',
                                   'id,ac_agt_id,ac_ses_id,ac_usr_id,convert(varchar, ac_time, 120) AS ac_time,ac_date,ac_week,ac_hour,
                                   ac_type,ac_subtype,ac_cls_id,ac_src_str,ac_dest_str',
                                   '','2','60','120','0')$;






Insert into genTableConfig values(2,'asset_change_log','CREATE TABLE asset_change_log (
    id Int64,
    ac_agt_id Int64,
    ac_ses_id Int64,
    ac_usr_id Int64,
    ac_time Nullable(String),
    ac_date Int64,
    ac_week Int64,
    ac_hour Int64,
    ac_type Int64,
    ac_subtype Int64,
    ac_cls_id Int64,
    ac_src_str String,
    ac_dest_str String
)engine= ReplacingMergeTree()
partition by ac_date
PRIMARY KEY (ac_date,id)
ORDER BY (ac_date,id);','ac_date','','','')$;






Insert into syncTableConfig values(1,'udisk_log',
                                   'id ,
                                 ud_agt_id ,
                                 ud_ses_id ,
                                 ud_usr_id ,
                                 convert(varchar, ud_time, 120) AS ud_time,
                                 ud_date ,
                                 ud_week ,
                                 ud_hour ,
                                 ud_type ,
                                 ud_subtype ,
                                 ud_udisk_id ,
                                 ud_volume_sn ,
                                 ud_udisk_encrypt_type ,
                                 ud_desc ,
                                 ud_label ,
                                 ud_udisk_size ,
                                 ud_encrypt_type ,
                                 ud_file_type ,
                                 ud_src_name ,
                                 ud_src_path ,
                                 ud_src_device ,
                                 ud_dest_path ,
                                 ud_dest_device ,
                                 ud_app_hash ,
                                 ud_app_name ,
                                 ud_app_title ,
                                 ud_file_time ,
                                 ud_file_size,
                                 ud_file_size_high,
                                 ud_ip_mac ,
                                 ud_pc_name ,
                                 ud_user_type ,
                                 ud_user_name ,
                                 ud_product_id ',
                                   '','2','60','120','0')$;



Insert into genTableConfig values(1,'udisk_log','CREATE TABLE udisk_log (
    id Int64,
    ud_agt_id Int64,
    ud_ses_id Int64,
    ud_usr_id Int64,
    ud_time String,
    ud_date Int64,
    ud_week Int64,
    ud_hour Int64,
    ud_type Int64,
    ud_subtype Int64,
    ud_udisk_id String,
    ud_volume_sn Int64,
    ud_udisk_encrypt_type Int64,
    ud_desc String,
    ud_label String,
    ud_udisk_size Int64,
    ud_encrypt_type Int64,
    ud_file_type Int64,
    ud_src_name String,
    ud_src_path String,
    ud_src_device Int64,
    ud_dest_path String,
    ud_dest_device Int64,
    ud_app_hash String,
    ud_app_name String,
    ud_app_title String,
    ud_file_time Datetime,
    ud_file_size Int64,
    ud_file_size_high Int64,
    ud_ip_mac String,
    ud_pc_name String,
    ud_user_type Int64,
    ud_user_name String,
    ud_product_id Int64
)engine= ReplacingMergeTree()
partition by ud_date
PRIMARY KEY (ud_date,id)
ORDER BY (ud_date,id)','ud_date','','','')$;


Insert into syncTableConfig values(3,'decrypt_auth_request','id, dar_type, dar_agt_id, dar_usr_id, dar_ses_id, CONVERT(varchar, dar_time, 120) as dar_timeStr, dar_date, dar_week, dar_hour, dar_file_names, dar_req_detail, STUFF((
        SELECT '','' + T2.FileInfo.value(''(Size)[1]'', ''VARCHAR(50)'')
        FROM (
            SELECT CAST(CAST(dar_req_detail AS NVARCHAR(MAX)) AS XML) AS XmlData
        ) AS X
        CROSS APPLY XmlData.nodes(''/ReqDetail/FileInfo'') AS T2(FileInfo)
        FOR XML PATH(''''), TYPE
    ).value(''.'', ''NVARCHAR(MAX)''), 1, 1, '''') AS dar_file_size,dar_req_finish, dar_appr_su_id, dar_appr_su_name, dar_appr_time, dar_appr_status, dar_appr_isread, dar_appr_detail, dar_res_status, dar_res_desc, dar_res_create_auth, dar_apply, dar_apply_time, dar_delete, dar_appr_flow_id, dar_cur_status_detail, dar_cur_node_id, dar_read_info, dar_push_result, dar_push_count, dar_push_context, dar_all_appr_su, dar_cur_appr_su','','1','60','120','0')$;




Insert into genTableConfig values(3,'decrypt_auth_request','CREATE TABLE IF NOT EXISTS decrypt_auth_request
(
    id Int64,
    dar_type Nullable(Int64),
    dar_agt_id Nullable(Int64),
    dar_usr_id Nullable(Int64),
    dar_ses_id Nullable(Int64),
    dar_timeStr Nullable(String),
    dar_time Nullable(DateTime) default toDateTime(dar_timeStr, ''Asia/Shanghai''),
    dar_date Int64,
    dar_week Nullable(Int64),
    dar_hour Nullable(Int64),
    dar_file_names Nullable(String),
    dar_req_detail Nullable(String),
    dar_req_finish Nullable(Int64),
    dar_appr_su_id Nullable(Int64),
    dar_appr_su_name Nullable(String),
    dar_appr_time Nullable(DateTime),
    dar_appr_status Nullable(Int64),
    dar_appr_isread Nullable(Int64),
    dar_appr_detail Nullable(String),
    dar_file_size Nullable(String),
    dar_res_status Nullable(Int64),
    dar_res_desc Nullable(String),
    dar_res_create_auth Nullable(Int64),
    dar_apply Nullable(Int64),
    dar_apply_time Nullable(DateTime),
    dar_delete Nullable(Int64),
    dar_appr_flow_id Nullable(Int64),
    dar_cur_status_detail Nullable(String),
    dar_cur_node_id Nullable(Int64),
    dar_read_info Nullable(String),
    dar_push_result Nullable(Int64),
    dar_push_count Nullable(Int64),
    dar_push_context Nullable(String),
    dar_all_appr_su Nullable(String),
    dar_cur_appr_su Nullable(String)
)
    ENGINE = ReplacingMergeTree()
PRIMARY KEY id
ORDER BY (id)
PARTITION BY dar_date
SETTINGS index_granularity = 8192;','dar_date','','','解密申请表')$;


Insert into syncTableConfig values(4,'decrypt_auth_request_log','id, dar_type, dar_agt_id, dar_usr_id, dar_ses_id, CONVERT(varchar, dar_time, 120) as dar_timeStr, dar_date, dar_week, dar_hour, dar_file_names, dar_req_detail, STUFF((
        SELECT '','' + T2.FileInfo.value(''(Size)[1]'', ''VARCHAR(50)'')
        FROM (
            SELECT CAST(CAST(dar_req_detail AS NVARCHAR(MAX)) AS XML) AS XmlData
        ) AS X
        CROSS APPLY XmlData.nodes(''/ReqDetail/FileInfo'') AS T2(FileInfo)
        FOR XML PATH(''''), TYPE
    ).value(''.'', ''NVARCHAR(MAX)''), 1, 1, '''') AS dar_file_size,dar_req_finish, dar_appr_su_id, dar_appr_su_name, dar_appr_time, dar_appr_status, dar_appr_isread, dar_appr_detail, dar_res_status, dar_res_desc, dar_res_create_auth, dar_apply, dar_apply_time, dar_delete, dar_appr_flow_id, dar_all_appr_su, dar_cur_appr_su, dar_cur_status_detail, dar_cur_node_id, dar_read_info, dar_push_result, dar_push_count, dar_push_context','','2','60','120','0')$;

Insert into genTableConfig values(4,'decrypt_auth_request_log','CREATE TABLE IF NOT EXISTS decrypt_auth_request_log
(
    id Int64,
    dar_type Nullable(Int64),
    dar_agt_id Nullable(Int64),
    dar_usr_id Nullable(Int64),
    dar_ses_id Nullable(Int64),
    dar_timeStr Nullable(String),
    dar_time Nullable(DateTime) default toDateTime(dar_timeStr, ''Asia/Shanghai''),
    dar_date Int64,
    dar_week Nullable(Int64),
    dar_hour Nullable(Int64),
    dar_file_names Nullable(String),
    dar_req_detail Nullable(String),
    dar_req_finish Nullable(Int64),
    dar_appr_su_id Nullable(Int64),
    dar_appr_su_name Nullable(String),
    dar_appr_time Nullable(DateTime),
    dar_appr_status Nullable(Int64),
    dar_appr_isread Nullable(Int64),
    dar_appr_detail Nullable(String),
    dar_file_size Nullable(String),
    dar_res_status Nullable(Int64),
    dar_res_desc Nullable(String),
    dar_res_create_auth Nullable(Int64),
    dar_apply Nullable(Int64),
    dar_apply_time Nullable(DateTime),
    dar_delete Nullable(Int64),
    dar_appr_flow_id Nullable(Int64),
    dar_all_appr_su Nullable(String),
    dar_cur_appr_su Nullable(String),
    dar_cur_status_detail Nullable(String),
    dar_cur_node_id Nullable(Int64),
    dar_read_info Nullable(String),
    dar_push_result Nullable(Int64),
    dar_push_count Nullable(Int64),
    dar_push_context Nullable(String)
)
    ENGINE = ReplacingMergeTree()
PRIMARY KEY id
ORDER BY (id)
PARTITION BY dar_date
SETTINGS index_granularity = 8192;','dar_date','','','解密申请表日志表')$;

Insert into syncTableConfig values(5,'approval_flow','id, af_id, af_name','','1','60','120','0')$;

Insert into genTableConfig values(5,'approval_flow','CREATE TABLE IF NOT EXISTS approval_flow
(
    id Int64,
    af_id Int64,
    af_name String
)
    ENGINE = ReplacingMergeTree()
PRIMARY KEY af_id
ORDER BY (af_id)
SETTINGS index_granularity = 8192;','','','','流程管理表')$;

INSERT INTO public.gentableconfig (id, tblname, gensql, partitioncol, queryfield, showfield, tabledesc) VALUES (17, 'common_approval_flow', e'CREATE TABLE common_approval_flow (
                              id Int64,
                              caf_id String,
                              caf_name String,
                              caf_ordinal Int64,
                              caf_request_type String,
                              caf_create_time DateTime,
                              caf_create_name String,
                              caf_modify_time DateTime,
                              caf_modify_name String,
                              caf_apply Int64,
                              caf_status Int64,
                              caf_status_desc String,
                              caf_content String
)engine= ReplacingMergeTree() PRIMARY KEY caf_id;', '', '', '', '流程基础数据')$;


INSERT INTO public.gentableconfig (id, tblname, gensql, partitioncol, queryfield, showfield, tabledesc) VALUES (11, 'auth_request_log', e'CREATE TABLE auth_request_log (
     id Int64,
     ar_request_type Int64,
     ar_history Int64,
     ar_online Int64,
     ar_agt_id Int64,
     ar_usr_id Int64,
     ar_ses_id Int64,
     ar_timeStr String,
     ar_time DateTime default toDateTime(ar_timeStr, \'Asia/Shanghai\'),
     ar_date Int64,
     ar_week Int64,
     ar_hour Int64,
     ar_req_detail String,
     ar_appr_flow_id String,  ar_req_detail_init String,
     ar_all_appr_su String,
     ar_cur_appr_su String,
     ar_appr_timeStr String,
     ar_appr_time DateTime default toDateTime(ar_appr_timeStr, \'Asia/Shanghai\'),
     ar_appr_status Int64,
     ar_appr_isread Int64,
     ar_appr_detail String,
     ar_res_status Int64,
     ar_res_desc String,
     ar_res_create_auth Int64,
     ar_apply Int64,
     ar_apply_timeStr String,
     ar_apply_time DateTime default toDateTime(ar_apply_timeStr, \'Asia/Shanghai\'),
     ar_exec Int64,
     ar_exec_beginStr String,
     ar_exec_begin  Nullable(DateTime) DEFAULT toDateTime(nullIf(ar_exec_beginStr, \'\'), \'Asia/Shanghai\'),
     ar_exec_endStr String,
     ar_exec_end  Nullable(DateTime) DEFAULT toDateTime(nullIf(ar_exec_endStr, \'\'), \'Asia/Shanghai\'),
     ar_auto_exec Int64,
     ar_delete Int64,
     ar_read_info String,
     ar_push_result Int64,
     ar_push_count Int64,
     ar_push_context String,
    extracted_path String MATERIALIZED if(
        position(ar_req_detail, \'<Path>\') > 0 AND position(ar_req_detail, \'</Path>\') > position(ar_req_detail, \'<Path>\'),
        substring(
            ar_req_detail,
            position(ar_req_detail, \'<Path>\') + length(\'<Path>\'),
            position(ar_req_detail, \'</Path>\') - position(ar_req_detail, \'<Path>\') - length(\'<Path>\')
        ),
        \'\'
    ),
    extracted_size String MATERIALIZED if(
        position(ar_req_detail, \'<Size>\') > 0
        AND position(ar_req_detail, \'</Size>\') > position(ar_req_detail, \'<Size>\'),
        substring(
            ar_req_detail,
            position(ar_req_detail, \'<Size>\') + length(\'<Size>\'),
            position(ar_req_detail, \'</Size>\') - position(ar_req_detail, \'<Size>\') - length(\'<Size>\')
        ),
        \'\'
    )
  )
  ENGINE = MergeTree()
  PARTITION BY ar_date
  PRIMARY KEY (ar_date, id)
  ORDER BY (ar_date, id)
', 'ar_date', '', '', '')$;


INSERT INTO public.gentableconfig (id, tblname, gensql, partitioncol, queryfield, showfield, tabledesc) VALUES (12, 'auth_request', e'CREATE TABLE auth_request (
     id Int64,
     ar_request_type Int64,
     ar_history Int64,
     ar_online Int64,
     ar_agt_id Int64,
     ar_usr_id Int64,
     ar_ses_id Int64,
     ar_appr_flow_id String,
     ar_timeStr String,
     ar_time DateTime default toDateTime(ar_timeStr, \'Asia/Shanghai\'),
     ar_date Int64,
     ar_week Int64,
     ar_hour Int64,
     ar_req_detail String,
     ar_req_detail_init String,
     ar_all_appr_su String,
     ar_cur_appr_su String,
     ar_appr_timeStr String,
     ar_appr_time DateTime default toDateTime(ar_appr_timeStr, \'Asia/Shanghai\'),
     ar_appr_status Int64,
     ar_appr_isread Int64,
     ar_appr_detail String,
     ar_res_status Int64,
     ar_res_desc String,
     ar_res_create_auth Int64,
     ar_apply Int64,
     ar_apply_timeStr String,
     ar_apply_time DateTime default toDateTime(ar_apply_timeStr, \'Asia/Shanghai\'),
     ar_exec Int64,
     ar_exec_beginStr String,
     ar_exec_begin  Nullable(DateTime) DEFAULT toDateTime(nullIf(ar_exec_beginStr, \'\'), \'Asia/Shanghai\'),
     ar_exec_endStr String,
     ar_exec_end  Nullable(DateTime) DEFAULT toDateTime(nullIf(ar_exec_endStr, \'\'), \'Asia/Shanghai\'),
     ar_auto_exec Int64,
     ar_delete Int64,
     ar_read_info String,
     ar_push_result Int64,
     ar_push_count Int64,
     ar_push_context String,
    extracted_path String MATERIALIZED if(
        position(ar_req_detail, \'<Path>\') > 0 AND position(ar_req_detail, \'</Path>\') > position(ar_req_detail, \'<Path>\'),
        substring(
            ar_req_detail,
            position(ar_req_detail, \'<Path>\') + length(\'<Path>\'),
            position(ar_req_detail, \'</Path>\') - position(ar_req_detail, \'<Path>\') - length(\'<Path>\')
        ),
        \'\'
    ),
    extracted_size String MATERIALIZED if(
        position(ar_req_detail, \'<Size>\') > 0
        AND position(ar_req_detail, \'</Size>\') > position(ar_req_detail, \'<Size>\'),
        substring(
            ar_req_detail,
            position(ar_req_detail, \'<Size>\') + length(\'<Size>\'),
            position(ar_req_detail, \'</Size>\') - position(ar_req_detail, \'<Size>\') - length(\'<Size>\')
        ),
        \'\'
    )
  )
  ENGINE = MergeTree()
  PARTITION BY ar_date
  PRIMARY KEY (ar_date, id)
  ORDER BY (ar_date, id)
', 'ar_date', '', '', '')$;

INSERT INTO public.gentableconfig (id, tblname, gensql, partitioncol, queryfield, showfield, tabledesc) VALUES (10, 'doc_watermark_log', e'CREATE TABLE doc_watermark_log (
    id Int64,
    doc_wm_agt_id Int64,
    doc_wm_ses_id Int64,
    doc_wm_usr_id Int64,
    doc_wm_timeStr String,
    doc_wm_time DateTime default toDateTime(doc_wm_timeStr, \'Asia/Shanghai\'),
    date_period String default toString(toDate(doc_wm_time)),
    week_period String default concat(toString(subtractDays(toDate(date_period) , dayOfWeek(toDate(date_period)) - 1)), \'~\', toString(addDays(subtractDays(toDate(date_period), dayOfWeek(toDate(date_period)) - 1), 6))),
    log_week_day String default toString(toMonday(doc_wm_time)),
    log_month_day String default substring(log_week_day,1,7),
    doc_wm_date Int64,
    doc_wm_week Int64,
    doc_wm_hour Int64,
    doc_wm_type Int64,
    doc_wm_subtype Int64,
    doc_wm_wmdotnum String,
    doc_wm_src_name String,
    doc_wm_src_path String,
    doc_wm_dest_path String,
    doc_wm_file_time DateTime,
    doc_wm_file_size Int64,
    doc_wm_file_flag Int64,
    doc_wm_templatename String,
    doc_wm_docnum String,
    doc_wm_msg_id Int64,
    doc_wm_msg_txt String
  )
  ENGINE = MergeTree()
  PARTITION BY doc_wm_date
  PRIMARY KEY (doc_wm_date, id)
  ORDER BY (doc_wm_date, id)', 'doc_wm_date', '', '', '')$;

INSERT INTO "public"."synctableconfig" ("id", "tblname", "fieldsql", "wheresql", "tbltype", "syncdays", "cleardays", "status", "errmessage") VALUES (10, 'doc_watermark_log', 'id,
                                        doc_wm_agt_id,
                                        doc_wm_ses_id,
                                        doc_wm_usr_id,
                                        CONVERT(varchar, doc_wm_time, 120) as doc_wm_timeStr,
                                        doc_wm_date,
                                        doc_wm_week,
                                        doc_wm_hour,
                                        doc_wm_type,
                                        doc_wm_subtype,
                                        doc_wm_wmdotnum,
                                        doc_wm_src_name,
                                        doc_wm_src_path,
                                        doc_wm_dest_path,
                                        doc_wm_file_time,
                                        doc_wm_file_size,
                                        doc_wm_file_flag,
                                        doc_wm_templatename,
                                        doc_wm_docnum,
                                        doc_wm_msg_id,
                                        doc_wm_msg_txt', 'doc_wm_subtype in (12,13)', '2', '60', '120', '0', '')$;


INSERT INTO "public"."synctableconfig" ("id", "tblname", "fieldsql", "wheresql", "tbltype", "syncdays", "cleardays", "status", "errmessage") VALUES (11, 'auth_request_log', 'id,
    ar_request_type,
    ar_agt_id,
    ar_usr_id,
    ar_ses_id,
    CONVERT(varchar, ar_time, 120) as ar_timeStr,
    ar_date,
    ar_req_detail,
    ar_req_detail_init,
    ar_all_appr_su,
    ar_cur_appr_su,
    CONVERT(varchar, ar_appr_time, 120) as ar_appr_timeStr,
    ar_appr_status,
    CAST(ar_appr_flow_id AS VARCHAR(36)) as ar_appr_flow_id,
    ar_appr_isread,
    ar_appr_detail,
    ar_res_status,
    ar_res_desc,
    ar_res_create_auth,
    ar_apply,
    CONVERT(varchar, ar_apply_time, 120) as ar_apply_timeStr,
    ar_exec,
    CONVERT(varchar, ar_exec_begin, 120) as ar_exec_beginStr,
    CONVERT(varchar, ar_exec_end, 120) as ar_exec_endStr,
    ar_auto_exec,
    ar_delete,
    ar_read_info,
    ar_push_result,
    ar_push_count,
   ar_push_context', 'ar_request_type in (14,16)', '2', '60', '120', '0', '')$;



INSERT INTO "public"."synctableconfig" ("id", "tblname", "fieldsql", "wheresql", "tbltype", "syncdays", "cleardays", "status", "errmessage") VALUES (12, 'auth_request', 'id,
   ar_request_type,
   ar_agt_id,
   ar_usr_id,
   ar_ses_id,
   CONVERT(varchar, ar_time, 120) as ar_timeStr,
   ar_date,
   ar_req_detail,
   ar_req_detail_init,
   ar_all_appr_su,
   ar_cur_appr_su,
   CONVERT(varchar, ar_appr_time, 120) as ar_appr_timeStr,
   ar_appr_status,
   ar_appr_isread,
   ar_appr_detail,
   CAST(ar_appr_flow_id AS VARCHAR(36)) as ar_appr_flow_id,
   ar_res_status,
   ar_res_desc,
   ar_res_create_auth,
   ar_apply,
    CONVERT(varchar, ar_apply_time, 120) as ar_apply_timeStr,
    ar_exec,
    CONVERT(varchar, ar_exec_begin, 120) as ar_exec_beginStr,
    CONVERT(varchar, ar_exec_end, 120) as ar_exec_endStr,
   ar_auto_exec,
   ar_delete,
   ar_read_info,
   ar_push_result,
   ar_push_count,
   ar_push_context', 'ar_request_type in (14,16)', '1', '60', '120', '0', '')$;

INSERT INTO "public"."synctableconfig" (id, tblname, fieldsql, wheresql, tbltype, syncdays, cleardays, status, errmessage) VALUES (17, 'common_approval_flow', 'id,CAST(caf_id AS VARCHAR(36)) as caf_id,caf_name,caf_ordinal,caf_request_type,caf_create_time,caf_create_name,caf_modify_time,caf_modify_name,
                                        caf_apply,caf_status,caf_status_desc,caf_content', '', '1', '60', '120', '0', '')$;


