DROP TABLE IF EXISTS software_agent_mv$;

CREATE TABLE biz_agent_utilization (
                                       id Int64,
                                       u_date Int32,
                                       agt_id Int32,
                                       agt_name String,
                                       agt_alias String,
                                       area_name String,
                                       dept_id Int32,
                                       dept_name String,
                                       install_num Int32,
                                       user_name String,
                                       user_alias String,
                                       user_grp_name String,
                                       agt_grp_id Int32,
                                       agt_grp_name String,
                                       agt_type String,
                                       agt_ip_real String,
                                       agt_mac_real String,
                                       soft_name String,
                                       use_days Int32,
                                       boot_days Int32,
                                       duration Int32,
                                       avg_duration Int32,
                                       open_time Int32,
                                       utilization Float32,
                                       update_time String default toString(toYYYYMMDDhhmmss(now()))
)engine= ReplacingMergeTree()
PRIMARY KEY (id)
ORDER BY (id)$;

CREATE TABLE biz_agent_utilization_curr (
                                            id Int64,
                                            u_date Int32,
                                            agt_id Int32,
                                            agt_name String,
                                            agt_alias String,
                                            area_name String,
                                            dept_id Int32,
                                            dept_name String,
                                            install_num Int32,
                                            user_name String,
                                            user_alias String,
                                            user_grp_name String,
                                            agt_grp_id Int32,
                                            agt_grp_name String,
                                            agt_type String,
                                            agt_ip_real String,
                                            agt_mac_real String,
                                            soft_name String,
                                            use_days Int32,
                                            boot_days Int32,
                                            duration Int32,
                                            avg_duration Int32,
                                            open_time Int32,
                                            utilization Float32,
                                            update_time String default toString(toYYYYMMDDhhmmss(now()))
)engine= ReplacingMergeTree()
PRIMARY KEY (id)
ORDER BY (id)$;

CREATE TABLE biz_agent_utilization_curr_temp (
                                                 id Int64,
                                                 u_date Int32,
                                                 agt_id Int32,
                                                 agt_name String,
                                                 agt_alias String,
                                                 area_name String,
                                                 dept_id Int32,
                                                 dept_name String,
                                                 install_num Int32,
                                                 user_name String,
                                                 user_alias String,
                                                 user_grp_name String,
                                                 agt_grp_id Int32,
                                                 agt_grp_name String,
                                                 agt_type String,
                                                 agt_ip_real String,
                                                 agt_mac_real String,
                                                 soft_name String,
                                                 use_days Int32,
                                                 boot_days Int32,
                                                 duration Int32,
                                                 avg_duration Int32,
                                                 open_time Int32,
                                                 utilization Float32,
                                                 update_time String default toString(toYYYYMMDDhhmmss(now()))
)engine= ReplacingMergeTree()
PRIMARY KEY (id)
ORDER BY (id)$;

CREATE TABLE agent_with_month_result (
                                         month String,                -- 月份
                                         agtId Int32,                 -- 代理ID
                                         agtGrpId Int32,
                                         depth Int32,
                                         userGroupName String,         -- 用户组名
                                         userAlias String,             -- 用户别名
                                         userName String,              -- 用户名
                                         macAddr String,               -- MAC地址
                                         ipAddr String,                -- IP地址
                                         agentAlias String,            -- 代理别名
                                         agentName String,             -- 代理名称
                                         areaId Int32,                 -- 区域id
                                         areaName String,              -- 区域名称
                                         deptId Int32,                 -- 部门id
                                         deptName String,              -- 部门名称
                                         groupName String,             -- 组名
                                         type String,                  -- 类型
                                         activeTime Int32,           -- 活跃时间
                                         bootTime Int32,             -- 启动时间
                                         bootTimeStr String,             -- 启动时间
                                         utilization Float64           -- 利用率
) ENGINE = ReplacingMergeTree()
PRIMARY KEY (month,agtId)
ORDER BY (month,agtId)$;


CREATE TABLE agent_with_month_result_new (
                                             agtId Int32,                 -- 代理ID
                                             agtGrpId Int32,
                                             depth Int32,
                                             userGroupName String,         -- 用户组名
                                             userAlias String,             -- 用户别名
                                             userName String,              -- 用户名
                                             macAddr String,               -- MAC地址
                                             ipAddr String,                -- IP地址
                                             agentAlias String,            -- 代理别名
                                             agentName String,             -- 代理名称
                                             areaId Int32,                 -- 区域id
                                             areaName String,              -- 区域名称
                                             deptId Int32,                 -- 部门id
                                             deptName String,              -- 部门名称
                                             groupName String,             -- 组名
                                             type String,                  -- 类型
                                             activeTime Int32,           -- 活跃时间
                                             bootTime Int32,             -- 启动时间
                                             bootTimeStr String,             -- 启动时间
                                             utilization Float64           -- 利用率
) ENGINE = ReplacingMergeTree()
PRIMARY KEY (agtId)
ORDER BY (agtId)$;


DROP TABLE IF EXISTS doc_decrypt_view$;

CREATE MATERIALIZED VIEW doc_decrypt_view
(
    `uid` String,
    `id` Int32,
    `log_type` Int32,
    `opt_type` String,
    `derive_type` String,
    `date_period` String,
    `week_period` String,
    `log_week_day` String,
    `log_month_day` String,
    `doc_agt_id` Int32,
    `doc_ses_id` Int32,
    `doc_usr_id` Int32,
    `doc_time` Nullable(DateTime),
    `doc_date` Int32,
    `doc_week` Int32,
    `doc_hour` Int32,
    `doc_type` Int32,
    `doc_subtype` String,
    `edoc_file_id` String,
    `doc_file_type` Int32,
    `doc_file_time` Nullable(DateTime),
    `doc_file_size` Int64,
    `doc_file_size_high` Int32,
    `doc_src_name` String,
    `doc_src_path` String,
    `doc_src_device` Int32,
    `doc_src_suffix` String,
    `doc_dest_name` String,
    `doc_dest_path` String,
    `doc_dest_device` Int32,
    `doc_dest_suffix` String,
    `doc_app_hash` String,
    `doc_app_name` String,
    `doc_app_title` String,
    `edoc_app_path` String,
    `edoc_app_id` Int32,
    `edoc_app_pid` Int32,
    `edoc_state` Int32,
    `edoc_req_id` String,
    `edoc_old_region` String,
    `edoc_old_level` Int32,
    `edoc_new_region` String,
    `edoc_new_level` Int32,
    `edoc_caution` Int32,
    `edoc_outgos` String,
    `edoc_memo` String,
    `doc_bak_id` String,
    `doc_bak_file` String,
    `doc_bak_type` Int32,
    `class_id` Array(Int32),
    `class_name` Array(String)
)
ENGINE = ReplacingMergeTree
    PARTITION BY doc_date
    PRIMARY KEY uid
    ORDER BY uid
    SETTINGS index_granularity = 8192
POPULATE AS
WITH lower(ifNull(doc_src_suffix, '')) AS doc_ext
SELECT
    uid,
    id,
    5 AS log_type,
    doc_subtype AS opt_type,
    derive_type,
    date_period,
    week_period,
    log_week_day,
    log_month_day,
    doc_agt_id,
    doc_ses_id,
    doc_usr_id,
    doc_time,
    doc_date,
    doc_week,
    doc_hour,
    doc_type,
    doc_subtype,
    edoc_file_id,
    doc_file_type,
    doc_file_time,
    doc_file_size,
    doc_file_size_high,
    doc_src_name,
    doc_src_path,
    doc_src_device,
    doc_src_suffix,
    doc_dest_name,
    doc_dest_path,
    doc_dest_device,
    doc_dest_suffix,
    doc_app_hash,
    doc_app_name,
    doc_app_title,
    edoc_app_path,
    edoc_app_id,
    edoc_app_pid,
    edoc_state,
    edoc_req_id,
    edoc_old_region,
    edoc_old_level,
    edoc_new_region,
    edoc_new_level,
    edoc_caution,
    edoc_outgos,
    edoc_memo,
    doc_bak_id,
    doc_bak_file,
    doc_bak_type,
    groupArray(class_id) AS class_id,
    groupArray(class_name) AS class_name
FROM doc_log
         LEFT JOIN (
    SELECT
        class_id, class_name,
        splitByString(',', replaceAll(lower(extend_content), '*.', '')) AS extend_content,
        status, enable_extend, enable_size, compare, value_byte, value2_byte
    FROM file_class
    WHERE status = 1
) f ON 1 = 1
WHERE doc_subtype LIKE 'e%'
  AND (
    (f.enable_extend = 1 AND f.enable_size = 1 AND f.compare = 1 AND has(f.extend_content, doc_ext) AND doc_file_size = f.value_byte) OR
    (f.enable_extend = 1 AND f.enable_size = 1 AND f.compare = 2 AND has(f.extend_content, doc_ext) AND doc_file_size > f.value_byte) OR
    (f.enable_extend = 1 AND f.enable_size = 1 AND f.compare = 3 AND has(f.extend_content, doc_ext) AND doc_file_size >= f.value_byte) OR
    (f.enable_extend = 1 AND f.enable_size = 1 AND f.compare = 4 AND has(f.extend_content, doc_ext) AND doc_file_size < f.value_byte) OR
    (f.enable_extend = 1 AND f.enable_size = 1 AND f.compare = 5 AND has(f.extend_content, doc_ext) AND doc_file_size <= f.value_byte) OR
    (f.enable_extend = 1 AND f.enable_size = 1 AND f.compare = 6 AND has(f.extend_content, doc_ext) AND doc_file_size BETWEEN f.value_byte AND f.value2_byte) OR
    (f.enable_extend = 1 AND f.enable_size = 0 AND has(f.extend_content, doc_ext)) OR
    (f.enable_extend = 0 AND f.enable_size = 1 AND f.compare = 1 AND doc_file_size = f.value_byte) OR
    (f.enable_extend = 0 AND f.enable_size = 1 AND f.compare = 2 AND doc_file_size > f.value_byte) OR
    (f.enable_extend = 0 AND f.enable_size = 1 AND f.compare = 3 AND doc_file_size >= f.value_byte) OR
    (f.enable_extend = 0 AND f.enable_size = 1 AND f.compare = 4 AND doc_file_size < f.value_byte) OR
    (f.enable_extend = 0 AND f.enable_size = 1 AND f.compare = 5 AND doc_file_size <= f.value_byte) OR
    (f.enable_extend = 0 AND f.enable_size = 1 AND f.compare = 6 AND doc_file_size BETWEEN f.value_byte AND f.value2_byte) OR
    (f.class_name = '无后缀文件' AND doc_ext = '') OR
    (f.class_name = '其他' AND NOT doc_ext IN (
                                               'psd','pdd','psb','max','drf','chr','ai','ait',
                                               'h','hh','hpp','hxx','cpp','cc','cxx','c','c++','cur','css','dll','dsp','dsw','opt','obj','clw','idl','inl','jar','js','json','sln','lib','node','rc','rc2','res','csproj','scss','sh','sln','so','vbs','vcxproj','vcproj','vue','xsd','a','i','ii','m','o','s','ss','cs','java','class','php','pm','py','py3','pyc','pyo','pyd','pyi','pyx','pyz','pywz','rpy','pyde','pyp','pyt','kt',
                                               'bmp','gif','jpe','jpeg','jpg','png','svg','tif','tiff',
                                               'rar','zip','7z','cab','lzh','jar','gz',
                                               'exe','com','sys','dll','bat',
                                               'doc','docx','docm','dotm','dotx','dot','xls','xlsx','xlsm','xlsb','xltx','xltm','xlt','xlam','xla','ppt','pptx','pptm','potx','potm','pot','ppsx','ppsm','pps','ppam','ppa','vsd','vsdx','vssx','vstx','vsdm','vssm','vstm','pdf','vdw','vss','vst','xps','wps','wpt','et','ett','dps','dpt','xmind','xmap','xmt','md','mm','mmap','mindnode','txt','rtf',
                                               'sldprt','sldasm','slddrw','asm','dft','par','psm','pwd','prt','fem','sim','afm','udf','drw','frm','mfg','lay','sec','dgm','rep','mrk','int','catproduct','stp','igs','iges','catpart',
                                               'exb','pcb','sch','prj',
                                               'dwg','dws','dxf','dwt','dwf','dwfx'
        ))
    )
GROUP BY
    uid, id, opt_type, log_type, derive_type, date_period, week_period, log_week_day, log_month_day,
    doc_agt_id, doc_ses_id, doc_usr_id, doc_time, doc_date, doc_week, doc_hour,
    doc_type, doc_subtype, edoc_file_id, doc_file_type, doc_file_time, doc_file_size, doc_file_size_high,
    doc_src_name, doc_src_path, doc_src_device, doc_src_suffix,
    doc_dest_name, doc_dest_path, doc_dest_device, doc_dest_suffix,
    doc_app_hash, doc_app_name, doc_app_title, edoc_app_path,
    edoc_app_id, edoc_app_pid, edoc_state, edoc_req_id,
    edoc_old_region, edoc_old_level, edoc_new_region, edoc_new_level,
    edoc_caution, edoc_outgos, edoc_memo, doc_bak_id, doc_bak_file, doc_bak_type$;
