DROP TABLE IF EXISTS software_agent_mv$;

CREATE TABLE biz_agent_utilization (
                                       id Int64,
                                       u_date Int32,
                                       agt_id Int32,
                                       agt_name String,
                                       agt_alias String,
                                       area_name String,
                                       dept_id Int32,
                                       dept_name String,
                                       install_num Int32,
                                       user_name String,
                                       user_alias String,
                                       user_grp_name String,
                                       agt_grp_id Int32,
                                       agt_grp_name String,
                                       agt_type String,
                                       agt_ip_real String,
                                       agt_mac_real String,
                                       soft_name String,
                                       use_days Int32,
                                       boot_days Int32,
                                       duration Int32,
                                       avg_duration Int32,
                                       open_time Int32,
                                       utilization Float32,
                                       update_time String default toString(toYYYYMMDDhhmmss(now()))
)engine= ReplacingMergeTree()
PRIMARY KEY (id)
ORDER BY (id)$;

CREATE TABLE biz_agent_utilization_curr (
                                            id Int64,
                                            u_date Int32,
                                            agt_id Int32,
                                            agt_name String,
                                            agt_alias String,
                                            area_name String,
                                            dept_id Int32,
                                            dept_name String,
                                            install_num Int32,
                                            user_name String,
                                            user_alias String,
                                            user_grp_name String,
                                            agt_grp_id Int32,
                                            agt_grp_name String,
                                            agt_type String,
                                            agt_ip_real String,
                                            agt_mac_real String,
                                            soft_name String,
                                            use_days Int32,
                                            boot_days Int32,
                                            duration Int32,
                                            avg_duration Int32,
                                            open_time Int32,
                                            utilization Float32,
                                            update_time String default toString(toYYYYMMDDhhmmss(now()))
)engine= ReplacingMergeTree()
PRIMARY KEY (id)
ORDER BY (id)$;

CREATE TABLE biz_agent_utilization_curr_temp (
                                                 id Int64,
                                                 u_date Int32,
                                                 agt_id Int32,
                                                 agt_name String,
                                                 agt_alias String,
                                                 area_name String,
                                                 dept_id Int32,
                                                 dept_name String,
                                                 install_num Int32,
                                                 user_name String,
                                                 user_alias String,
                                                 user_grp_name String,
                                                 agt_grp_id Int32,
                                                 agt_grp_name String,
                                                 agt_type String,
                                                 agt_ip_real String,
                                                 agt_mac_real String,
                                                 soft_name String,
                                                 use_days Int32,
                                                 boot_days Int32,
                                                 duration Int32,
                                                 avg_duration Int32,
                                                 open_time Int32,
                                                 utilization Float32,
                                                 update_time String default toString(toYYYYMMDDhhmmss(now()))
)engine= ReplacingMergeTree()
PRIMARY KEY (id)
ORDER BY (id)$;

CREATE TABLE agent_with_month_result (
                                         month String,                -- 月份
                                         agtId Int32,                 -- 代理ID
                                         agtGrpId Int32,
                                         depth Int32,
                                         userGroupName String,         -- 用户组名
                                         userAlias String,             -- 用户别名
                                         userName String,              -- 用户名
                                         macAddr String,               -- MAC地址
                                         ipAddr String,                -- IP地址
                                         agentAlias String,            -- 代理别名
                                         agentName String,             -- 代理名称
                                         areaId Int32,                 -- 区域id
                                         areaName String,              -- 区域名称
                                         deptId Int32,                 -- 部门id
                                         deptName String,              -- 部门名称
                                         groupName String,             -- 组名
                                         type String,                  -- 类型
                                         activeTime Int32,           -- 活跃时间
                                         bootTime Int32,             -- 启动时间
                                         bootTimeStr String,             -- 启动时间
                                         utilization Float64           -- 利用率
) ENGINE = ReplacingMergeTree()
PRIMARY KEY (month,agtId)
ORDER BY (month,agtId)$;


CREATE TABLE agent_with_month_result_new (
                                             agtId Int32,                 -- 代理ID
                                             agtGrpId Int32,
                                             depth Int32,
                                             userGroupName String,         -- 用户组名
                                             userAlias String,             -- 用户别名
                                             userName String,              -- 用户名
                                             macAddr String,               -- MAC地址
                                             ipAddr String,                -- IP地址
                                             agentAlias String,            -- 代理别名
                                             agentName String,             -- 代理名称
                                             areaId Int32,                 -- 区域id
                                             areaName String,              -- 区域名称
                                             deptId Int32,                 -- 部门id
                                             deptName String,              -- 部门名称
                                             groupName String,             -- 组名
                                             type String,                  -- 类型
                                             activeTime Int32,           -- 活跃时间
                                             bootTime Int32,             -- 启动时间
                                             bootTimeStr String,             -- 启动时间
                                             utilization Float64           -- 利用率
) ENGINE = ReplacingMergeTree()
PRIMARY KEY (agtId)
ORDER BY (agtId)$;


DROP TABLE IF EXISTS doc_decrypt_view$;

CREATE MATERIALIZED VIEW doc_decrypt_view
(
    `uid` String,
    `id` Int32,
    `log_type` Int32,
    `opt_type` String,
    `derive_type` String,
    `date_period` String,
    `week_period` String,
    `log_week_day` String,
    `log_month_day` String,
    `doc_agt_id` Int32,
    `doc_ses_id` Int32,
    `doc_usr_id` Int32,
    `doc_time` Nullable(DateTime),
    `doc_date` Int32,
    `doc_week` Int32,
    `doc_hour` Int32,
    `doc_type` Int32,
    `doc_subtype` String,
    `edoc_file_id` String,
    `doc_file_type` Int32,
    `doc_file_time` Nullable(DateTime),
    `doc_file_size` Int64,
    `doc_file_size_high` Int32,
    `doc_src_name` String,
    `doc_src_path` String,
    `doc_src_device` Int32,
    `doc_src_suffix` String,
    `doc_dest_name` String,
    `doc_dest_path` String,
    `doc_dest_device` Int32,
    `doc_dest_suffix` String,
    `doc_app_hash` String,
    `doc_app_name` String,
    `doc_app_title` String,
    `edoc_app_path` String,
    `edoc_app_id` Int32,
    `edoc_app_pid` Int32,
    `edoc_state` Int32,
    `edoc_req_id` String,
    `edoc_old_region` String,
    `edoc_old_level` Int32,
    `edoc_new_region` String,
    `edoc_new_level` Int32,
    `edoc_caution` Int32,
    `edoc_outgos` String,
    `edoc_memo` String,
    `doc_bak_id` String,
    `doc_bak_file` String,
    `doc_bak_type` Int32,
    `class_id` Array(Int32),
    `class_name` Array(String)
)
ENGINE = ReplacingMergeTree
    PARTITION BY doc_date
    PRIMARY KEY uid
    ORDER BY uid
    SETTINGS index_granularity = 8192
POPULATE AS
WITH lower(ifNull(doc_src_suffix, '')) AS doc_ext
SELECT
    uid,
    id,
    5 AS log_type,
    doc_subtype AS opt_type,
    derive_type,
    date_period,
    week_period,
    log_week_day,
    log_month_day,
    doc_agt_id,
    doc_ses_id,
    doc_usr_id,
    doc_time,
    doc_date,
    doc_week,
    doc_hour,
    doc_type,
    doc_subtype,
    edoc_file_id,
    doc_file_type,
    doc_file_time,
    doc_file_size,
    doc_file_size_high,
    doc_src_name,
    doc_src_path,
    doc_src_device,
    doc_src_suffix,
    doc_dest_name,
    doc_dest_path,
    doc_dest_device,
    doc_dest_suffix,
    doc_app_hash,
    doc_app_name,
    doc_app_title,
    edoc_app_path,
    edoc_app_id,
    edoc_app_pid,
    edoc_state,
    edoc_req_id,
    edoc_old_region,
    edoc_old_level,
    edoc_new_region,
    edoc_new_level,
    edoc_caution,
    edoc_outgos,
    edoc_memo,
    doc_bak_id,
    doc_bak_file,
    doc_bak_type,
    groupArray(class_id) AS class_id,
    groupArray(class_name) AS class_name
FROM doc_log
         LEFT JOIN (
    SELECT
        class_id, class_name,
        splitByString(',', replaceAll(lower(extend_content), '*.', '')) AS extend_content,
        status, enable_extend, enable_size, compare, value_byte, value2_byte
    FROM file_class
    WHERE status = 1
) f ON 1 = 1
WHERE doc_subtype LIKE 'e%'
  AND (
    (f.enable_extend = 1 AND f.enable_size = 1 AND f.compare = 1 AND has(f.extend_content, doc_ext) AND doc_file_size = f.value_byte) OR
    (f.enable_extend = 1 AND f.enable_size = 1 AND f.compare = 2 AND has(f.extend_content, doc_ext) AND doc_file_size > f.value_byte) OR
    (f.enable_extend = 1 AND f.enable_size = 1 AND f.compare = 3 AND has(f.extend_content, doc_ext) AND doc_file_size >= f.value_byte) OR
    (f.enable_extend = 1 AND f.enable_size = 1 AND f.compare = 4 AND has(f.extend_content, doc_ext) AND doc_file_size < f.value_byte) OR
    (f.enable_extend = 1 AND f.enable_size = 1 AND f.compare = 5 AND has(f.extend_content, doc_ext) AND doc_file_size <= f.value_byte) OR
    (f.enable_extend = 1 AND f.enable_size = 1 AND f.compare = 6 AND has(f.extend_content, doc_ext) AND doc_file_size BETWEEN f.value_byte AND f.value2_byte) OR
    (f.enable_extend = 1 AND f.enable_size = 0 AND has(f.extend_content, doc_ext)) OR
    (f.enable_extend = 0 AND f.enable_size = 1 AND f.compare = 1 AND doc_file_size = f.value_byte) OR
    (f.enable_extend = 0 AND f.enable_size = 1 AND f.compare = 2 AND doc_file_size > f.value_byte) OR
    (f.enable_extend = 0 AND f.enable_size = 1 AND f.compare = 3 AND doc_file_size >= f.value_byte) OR
    (f.enable_extend = 0 AND f.enable_size = 1 AND f.compare = 4 AND doc_file_size < f.value_byte) OR
    (f.enable_extend = 0 AND f.enable_size = 1 AND f.compare = 5 AND doc_file_size <= f.value_byte) OR
    (f.enable_extend = 0 AND f.enable_size = 1 AND f.compare = 6 AND doc_file_size BETWEEN f.value_byte AND f.value2_byte) OR
    (f.class_name = '无后缀文件' AND doc_ext = '') OR
    (f.class_name = '其他' AND NOT doc_ext IN (
                                               'psd','pdd','psb','max','drf','chr','ai','ait',
                                               'h','hh','hpp','hxx','cpp','cc','cxx','c','c++','cur','css','dll','dsp','dsw','opt','obj','clw','idl','inl','jar','js','json','sln','lib','node','rc','rc2','res','csproj','scss','sh','sln','so','vbs','vcxproj','vcproj','vue','xsd','a','i','ii','m','o','s','ss','cs','java','class','php','pm','py','py3','pyc','pyo','pyd','pyi','pyx','pyz','pywz','rpy','pyde','pyp','pyt','kt',
                                               'bmp','gif','jpe','jpeg','jpg','png','svg','tif','tiff',
                                               'rar','zip','7z','cab','lzh','jar','gz',
                                               'exe','com','sys','dll','bat',
                                               'doc','docx','docm','dotm','dotx','dot','xls','xlsx','xlsm','xlsb','xltx','xltm','xlt','xlam','xla','ppt','pptx','pptm','potx','potm','pot','ppsx','ppsm','pps','ppam','ppa','vsd','vsdx','vssx','vstx','vsdm','vssm','vstm','pdf','vdw','vss','vst','xps','wps','wpt','et','ett','dps','dpt','xmind','xmap','xmt','md','mm','mmap','mindnode','txt','rtf',
                                               'sldprt','sldasm','slddrw','asm','dft','par','psm','pwd','prt','fem','sim','afm','udf','drw','frm','mfg','lay','sec','dgm','rep','mrk','int','catproduct','stp','igs','iges','catpart',
                                               'exb','pcb','sch','prj',
                                               'dwg','dws','dxf','dwt','dwf','dwfx'
        ))
    )
GROUP BY
    uid, id, opt_type, log_type, derive_type, date_period, week_period, log_week_day, log_month_day,
    doc_agt_id, doc_ses_id, doc_usr_id, doc_time, doc_date, doc_week, doc_hour,
    doc_type, doc_subtype, edoc_file_id, doc_file_type, doc_file_time, doc_file_size, doc_file_size_high,
    doc_src_name, doc_src_path, doc_src_device, doc_src_suffix,
    doc_dest_name, doc_dest_path, doc_dest_device, doc_dest_suffix,
    doc_app_hash, doc_app_name, doc_app_title, edoc_app_path,
    edoc_app_id, edoc_app_pid, edoc_state, edoc_req_id,
    edoc_old_region, edoc_old_level, edoc_new_region, edoc_new_level,
    edoc_caution, edoc_outgos, edoc_memo, doc_bak_id, doc_bak_file, doc_bak_type$;

-- 文件日志表
CREATE TABLE file_log (
    -- 文件标识
                          file_id UInt64,                                -- 文件ID，唯一标识文件

    -- 终端和用户信息
                          agt_id Int32,                                 -- 终端ID
                          usr_id Int32,                                 -- 用户ID

    -- 文件基本信息
                          file_name String,                             -- 文件名称
                          file_path String,                             -- 文件路径

    -- 文件标签信息
                          sec_level Int32,                             -- 文件密级
                          find_label Array(String),                     -- 发现的文件标签
                          unfind_label Array(String),                   -- 未发现的文件标签
                          class_level Int32,                           -- 文件分类等级
                          match_info_class Array(String),               -- 命中的信息分类
                          unmatch_info_class Array(String),             -- 未命中的信息分类
                          class_info_detail String,                     -- 命中信息分类详情

    -- 文件时间属性
                          create_time DateTime,                         -- 文件创建时间
                          access_time DateTime,                         -- 文件访问时间
                          modify_time DateTime,                         -- 文件修改时间
                          file_size Int64,                              -- 文件大小

    -- 其他字段
                          last_file_time DateTime                       -- 最近发现时间

) ENGINE = MergeTree()
-- 按照创建时间进行分区，以便对不同时间段的数据进行查询优化
PARTITION BY agt_id     -- 每个终端一个分区
-- 按文件ID进行排序，优化按文件ID查询性能
ORDER BY file_id                                -- 按文件ID排序，优化按文件ID查询
-- 设置合并设置，优化磁盘存储及查询效率
SETTINGS index_granularity = 8192$;              -- 设置较大的索引粒度，提升读取性能，减少磁盘IO

-- string位图
CREATE TABLE file_log_bitmap
(
    `date` Int32,
    `label` LowCardinality(String),
    `value` String,
    `file_id` AggregateFunction(groupBitmap,UInt64)
)
    ENGINE = AggregatingMergeTree
PARTITION BY date
PRIMARY KEY (value,date,label)
ORDER BY (value,date,label)
SETTINGS index_granularity = 4$;
ALTER TABLE file_log_bitmap
    ADD INDEX label_bloom_filter (label) TYPE bloom_filter(0.01) GRANULARITY 1$;

-- int位图
CREATE TABLE file_log_bitmap_int
(
    `date` Int32,
    `label` LowCardinality(String),
    `value` Int32,
    `file_id` AggregateFunction(groupBitmap,UInt64)
)
    ENGINE = AggregatingMergeTree
PARTITION BY date
PRIMARY KEY (value,date,label)
ORDER BY (value,date,label)
SETTINGS index_granularity = 4$;
ALTER TABLE file_log_bitmap
    ADD INDEX label_bloom_filter_int (label) TYPE bloom_filter(0.01) GRANULARITY 1$;

-- 同步位图的物化视图
CREATE MATERIALIZED VIEW file_log_bitmap_find_lable
TO file_log_bitmap
AS
SELECT
    toInt32(formatDateTime(toTimeZone(last_file_time, 'Asia/Shanghai'), '%Y%m%d')) AS date,
    'find_label' AS label,
    arrayJoin(find_label) AS value,
    groupBitmapState(file_id) AS file_id
FROM file_log
GROUP BY (date, value)$;


CREATE MATERIALIZED VIEW file_log_bitmap_unfind_lable
TO file_log_bitmap
AS
SELECT
    toInt32(formatDateTime(toTimeZone(last_file_time, 'Asia/Shanghai'), '%Y%m%d')) AS date,
    'unfind_label' AS label,
    arrayJoin(unfind_label) AS value,
    groupBitmapState(file_id) AS file_id
FROM file_log
GROUP BY (date, value)$;

CREATE MATERIALIZED VIEW file_log_bitmap_sec_level
TO file_log_bitmap
AS
SELECT
    toInt32(formatDateTime(toTimeZone(last_file_time, 'Asia/Shanghai'), '%Y%m%d')) AS date,
    'sec_level' AS label,
    sec_level AS value,
    groupBitmapState(file_id) AS file_id
FROM file_log
GROUP BY (date, value)$;

CREATE MATERIALIZED VIEW file_log_bitmap_agt_id
TO file_log_bitmap_int
AS
SELECT
    toInt32(formatDateTime(toTimeZone(last_file_time, 'Asia/Shanghai'), '%Y%m%d')) AS date,
    'agt_id' AS label,
    agt_id AS value,
    groupBitmapState(file_id) AS file_id
FROM file_log
GROUP BY (date, value)$;


CREATE MATERIALIZED VIEW file_log_bitmap_usr_id
TO file_log_bitmap_int
AS
SELECT
    toInt32(formatDateTime(toTimeZone(last_file_time, 'Asia/Shanghai'), '%Y%m%d')) AS date,
    'usr_id' AS label,
    usr_id AS value,
    groupBitmapState(file_id) AS file_id
FROM file_log
GROUP BY (date, value)$;

CREATE MATERIALIZED VIEW file_log_bitmap_class_level
TO file_log_bitmap
AS
SELECT
    toInt32(formatDateTime(toTimeZone(last_file_time, 'Asia/Shanghai'), '%Y%m%d')) AS date,
    'class_level' AS label,
    class_level AS value,
    groupBitmapState(file_id) AS file_id
FROM file_log
GROUP BY (date, value)$;

CREATE MATERIALIZED VIEW file_log_bitmap_match_info_class
TO file_log_bitmap
AS
SELECT
    toInt32(formatDateTime(toTimeZone(last_file_time, 'Asia/Shanghai'), '%Y%m%d')) AS date,
    'match_info_class' AS label,
    arrayJoin(match_info_class) AS value,
    groupBitmapState(file_id) AS file_id
FROM file_log
GROUP BY (date, value)$;

CREATE MATERIALIZED VIEW file_log_bitmap_unmatch_info_class
TO file_log_bitmap
AS
SELECT
    toInt32(formatDateTime(toTimeZone(last_file_time, 'Asia/Shanghai'), '%Y%m%d')) AS date,
    'unmatch_info_class' AS label,
    arrayJoin(unmatch_info_class) AS value,
    groupBitmapState(file_id) AS file_id
FROM file_log
GROUP BY (date, value)$;


-- 创建字典
-- 信息分类字典
CREATE DICTIONARY dict_infoclass
(
    sil_id String,
    sil_name String,
    sec_id Int32
)
PRIMARY KEY sil_id
SOURCE(POSTGRESQL(HOST '$HOST' PORT $PORT USER '$USER' PASSWORD '$PASSWORD' DB '$DB' TABLE 'sci_infoclass_lib'))
LIFETIME(MIN 60 MAX 300)
LAYOUT(COMPLEX_KEY_HASHED())$;

-- 分类等级字典
CREATE DICTIONARY dict_sec_level
(
    `level` Int32,
    `name` String
)
PRIMARY KEY level
SOURCE(POSTGRESQL(HOST '$HOST' PORT $PORT USER '$USER' PASSWORD '$PASSWORD' DB '$DB' TABLE 'sec_level_lib'))
LIFETIME(MIN 60 MAX 300)
LAYOUT(COMPLEX_KEY_HASHED())$;
