CREATE TABLE base_attendance_transition (
                                            id Int64,
                                            user_id Int32,
                                            work_date Int32,
                                            weekday Int32,
                                            day_type Int32,
                                            work_start DateTime,
                                            work_end DateTime,
                                            attendance_type Int32,
                                            work_duration_ms Int64,
                                            standard_start DateTime,
                                            standard_end DateTime,
                                            work_seconds Int32,
                                            late_seconds Int32,
                                            overtime_seconds Int32,
                                            update_time String default toString(toYYYYMMDDhhmmss(now()))
)engine= ReplacingMergeTree()
PRIMARY KEY (id)
ORDER BY (id,user_id,work_date)$;

CREATE TABLE base_attendance (
                                 id Int64,
                                 user_id Int32,
                                 work_date Int32,
                                 weekday Int32,
                                 day_type Int32,
                                 work_start DateTime,
                                 work_end DateTime,
                                 attendance_type Int32,
                                 work_duration_ms Int64,
                                 standard_start DateTime,
                                 standard_end DateTime,
                                 work_seconds Int32,
                                 late_seconds Int32,
                                 overtime_seconds Int32,
                                 update_time String default toString(toYYYYMMDDhhmmss(now()))
)engine= ReplacingMergeTree()
PRIMARY KEY (id)
ORDER BY (id,user_id,work_date)$;


CREATE DICTIONARY attendance_weekend_setting
(
    id Int64,
    rest_type Int32,
    single_rest_day String DEFAULT '',
    created_at DateTime64(6),
    updated_at DateTime64(6)
)
PRIMARY KEY id
SOURCE(POSTGRESQL(HOST '$HOST' PORT $PORT USER '$USER' PASSWORD '$PASSWORD' DB '$DB' TABLE 'attendance_weekend_setting'))
LIFETIME(MIN 1 MAX 5)
LAYOUT(COMPLEX_KEY_HASHED())$;

CREATE DICTIONARY attendance_holiday_setting
(
    id Int64,
    holiday_type Int8,
    holiday_date Date,
    remark String DEFAULT '',
    created_at DateTime64(6),
    updated_at DateTime64(6)
)
PRIMARY KEY id
SOURCE(POSTGRESQL(HOST '$HOST' PORT $PORT USER '$USER' PASSWORD '$PASSWORD' DB '$DB' TABLE 'attendance_holiday_setting'))
LIFETIME(MIN 1 MAX 5)
LAYOUT(COMPLEX_KEY_HASHED())$;

CREATE DICTIONARY attendance_time_setting
(
    id Int64,
    attendance_type Int32,
    work_duration_ms Int32,
    work_start String,
    work_end String,
    break_start String,
    break_end String,
    created_at DateTime64(6),
    updated_at DateTime64(6)
)
PRIMARY KEY id
SOURCE(POSTGRESQL(HOST '$HOST' PORT $PORT USER '$USER' PASSWORD '$PASSWORD' DB '$DB' TABLE 'attendance_time_setting'))
LIFETIME(MIN 1 MAX 5)
LAYOUT(COMPLEX_KEY_HASHED())$;

CREATE DICTIONARY attendance_time_group
(
    id Int64,
    attendance_setting_id Int64,
    group_id Int64,
    group_node String DEFAULT '',
    created_at DateTime64(6)
)
PRIMARY KEY id
SOURCE(POSTGRESQL(HOST '$HOST' PORT $PORT USER '$USER' PASSWORD '$PASSWORD' DB '$DB' TABLE 'attendance_time_group'))
LIFETIME(MIN 1 MAX 5)
LAYOUT(COMPLEX_KEY_HASHED())$;

CREATE DICTIONARY attendance_other_setting
(
    id Int64,
    cutoff_time String DEFAULT '06:00:00',
    min_work_duration_ms Int32 DEFAULT 3600000,
    min_overtime_duration_ms Int32 DEFAULT 1800000,
    created_at DateTime64(6),
    updated_at DateTime64(6)
)
PRIMARY KEY id
SOURCE(POSTGRESQL(HOST '$HOST' PORT $PORT USER '$USER' PASSWORD '$PASSWORD' DB '$DB' TABLE 'attendance_other_setting'))
LIFETIME(MIN 1 MAX 5)
LAYOUT(COMPLEX_KEY_HASHED())$;
