ALTER TABLE file_class
    ADD COLUMN class_name_tw varchar(1000),
ADD COLUMN class_name_en varchar(1000)$;


UPDATE file_class
SET
    class_name_tw = CASE class_name
                        WHEN '办公文件' THEN '辦公檔案'
                        WHEN '图片文件' THEN '圖片檔案'
                        WHEN '代码文件' THEN '代碼檔案'
                        WHEN '压缩文件' THEN '壓縮檔案'
                        WHEN '可执行文件' THEN '可執行檔案'
                        WHEN '二维图纸文件' THEN '二維圖紙檔案'
                        WHEN '三维图纸文件' THEN '三維圖紙檔案'
                        WHEN '电子电路图纸' THEN '電子電路圖紙'
                        WHEN '图像设计图纸' THEN '影像設計圖紙'
                        WHEN '无后缀文件' THEN '無後綴檔案'
                        WHEN 'IM传送' THEN 'IM傳送'
                        WHEN '浏览器上传' THEN '瀏覽器上傳'
                        WHEN '复制到移动盘' THEN '複製到移動儲存'
                        WHEN '网盘上传' THEN '網盤上傳'
                        WHEN 'SVN/GIT上传' THEN 'SVN/GIT上傳'
                        WHEN 'FTP上传' THEN 'FTP上傳'
                        WHEN '其他' THEN '其他'
                        ELSE class_name_tw
        END,
    class_name_en = CASE class_name
                        WHEN '办公文件' THEN 'Office documents'
                        WHEN '图片文件' THEN 'Picture files'
                        WHEN '代码文件' THEN 'Code files'
                        WHEN '压缩文件' THEN 'Compressed files'
                        WHEN '可执行文件' THEN 'Executable files'
                        WHEN '二维图纸文件' THEN '2D drawings'
                        WHEN '三维图纸文件' THEN '3D drawings'
                        WHEN '电子电路图纸' THEN 'Electronic circuit diagrams'
                        WHEN '图像设计图纸' THEN 'Image designs'
                        WHEN '无后缀文件' THEN 'Files without suffixes'
                        WHEN 'IM传送' THEN 'Instant messaging'
                        WHEN '浏览器上传' THEN 'Browser upload'
                        WHEN '复制到移动盘' THEN 'Copy to mobile disk'
                        WHEN '网盘上传' THEN 'Cloud disk upload'
                        WHEN 'SVN/GIT上传' THEN 'SVN/GIT upload'
                        WHEN 'FTP上传' THEN 'FTP upload'
                        WHEN '其他' THEN 'Other'
                        ELSE class_name_en
        END $;

-- 删除原有视图
DROP VIEW IF EXISTS file_class_view$;

-- 重新创建视图
CREATE VIEW file_class_view
            (
             class_id,
             class_name,
             class_name_tw,
             class_name_en,
             extend_content,
             status,
             enable_extend,
             enable_size,
             compare,
             value,
             unit,
             value2,
             unit2,
             value_byte,
             value2_byte
                ) AS
SELECT fc.class_id,
       fc.class_name,
       fc.class_name_tw   AS class_name_tw,
       fc.class_name_en   AS class_name_en,
       fc.extend_content,
       fc.status,
       fc.enable_extend,
       fc.enable_size,
       fc.compare,
       fc.value,
       fc.unit,
       fc.value2,
       fc.unit2,
       fc.value_byte,
       fc.value2_byte
FROM file_class fc
WHERE fc.restore_id <> 0 $;


ALTER TABLE send_type
    ADD COLUMN st_name_tw varchar(1000),
ADD COLUMN st_name_en varchar(1000)$;



UPDATE send_type
SET
    st_name_tw = CASE st_name
                        WHEN '办公文件' THEN '辦公檔案'
                        WHEN '图片文件' THEN '圖片檔案'
                        WHEN '代码文件' THEN '代碼檔案'
                        WHEN '压缩文件' THEN '壓縮檔案'
                        WHEN '可执行文件' THEN '可執行檔案'
                        WHEN '二维图纸文件' THEN '二維圖紙檔案'
                        WHEN '三维图纸文件' THEN '三維圖紙檔案'
                        WHEN '电子电路图纸' THEN '電子電路圖紙'
                        WHEN '图像设计图纸' THEN '影像設計圖紙'
                        WHEN '无后缀文件' THEN '無後綴檔案'
                        WHEN 'IM传送' THEN 'IM傳送'
                        WHEN '浏览器上传' THEN '瀏覽器上傳'
                        WHEN '复制到移动盘' THEN '複製到移動儲存'
                        WHEN '网盘上传' THEN '網盤上傳'
                        WHEN 'SVN/GIT上传' THEN 'SVN/GIT上傳'
                        WHEN 'FTP上传' THEN 'FTP上傳'
                        WHEN '其他' THEN '其他'
                        WHEN '复制到网络盘' THEN '複製到網路碟'
                        ELSE st_name_tw
        END,
    st_name_en = CASE st_name
                        WHEN '办公文件' THEN 'Office documents'
                        WHEN '图片文件' THEN 'Picture files'
                        WHEN '代码文件' THEN 'Code files'
                        WHEN '压缩文件' THEN 'Compressed files'
                        WHEN '可执行文件' THEN 'Executable files'
                        WHEN '二维图纸文件' THEN '2D drawings'
                        WHEN '三维图纸文件' THEN '3D drawings'
                        WHEN '电子电路图纸' THEN 'Electronic circuit diagrams'
                        WHEN '图像设计图纸' THEN 'Image designs'
                        WHEN '无后缀文件' THEN 'Files without suffixes'
                        WHEN 'IM传送' THEN 'Instant messaging'
                        WHEN '浏览器上传' THEN 'Browser upload'
                        WHEN '复制到移动盘' THEN 'Copy to mobile disk'
                        WHEN '网盘上传' THEN 'Cloud disk upload'
                        WHEN 'SVN/GIT上传' THEN 'SVN/GIT upload'
                        WHEN 'FTP上传' THEN 'FTP upload'
                        WHEN '其他' THEN 'Other'
                        WHEN '复制到网络盘' THEN 'Copy to network disk'
                        ELSE st_name_en
        END $;



ALTER TABLE soft_classification
    ADD COLUMN name_tw varchar(1000),
ADD COLUMN name_en varchar(1000)$;


UPDATE soft_classification
SET name_tw = '__focus__', name_en = '__focus__'
WHERE id = 1$;
UPDATE soft_classification
SET name_tw = '__noclassification__', name_en = '__noclassification__'
WHERE id = 2$;


UPDATE soft_classification
SET name_tw = '辦公軟體', name_en = 'Office File'
WHERE id = 16$;

UPDATE soft_classification
SET name_tw = '圖形影像設計', name_en = 'Photo & Media Design'
WHERE id = 17$;

UPDATE soft_classification
SET name_tw = '二維工程設計', name_en = 'Engineering Design'
WHERE id = 18$;

UPDATE soft_classification
SET name_tw = '三維工程設計', name_en = 'TD-Engineering Design'
WHERE id = 19$;

UPDATE soft_classification
SET name_tw = '電子電路設計', name_en = 'Electronics Design'
WHERE id = 20$;

UPDATE soft_classification
SET name_tw = '文書處理', name_en = 'Text Editor'
WHERE id = 21$;

UPDATE soft_classification
SET name_tw = '編程開發', name_en = 'Programming'
WHERE id = 22$;

UPDATE soft_classification
SET name_tw = '多媒體軟體', name_en = 'Multimedia Software'
WHERE id = 23$;

UPDATE soft_classification
SET name_tw = '管理軟體', name_en = 'ERP System'
WHERE id = 24$;

UPDATE soft_classification
SET name_tw = '教育教學軟體', name_en = 'Educational Software'
WHERE id = 25$;

UPDATE soft_classification
SET name_tw = '統計分析', name_en = 'Statistical Analysis'
WHERE id = 26$;

UPDATE soft_classification
SET name_tw = '光學分析', name_en = 'Optical Analysis'
WHERE id = 27$;

UPDATE soft_classification
SET name_tw = 'CAE軟體', name_en = 'CAE Software'
WHERE id = 28$;

UPDATE soft_classification
SET name_tw = '版權軟體', name_en = 'Copyright Software'
WHERE id = 33$;
