drop table syncTableConfig$;

drop table genTableConfig$;

CREATE TABLE syncTableConfig(
                                id int PRIMARY KEY,
                                tblName varchar(100),
                                fieldSqlMs varchar(5000),
                                fieldSqlMy varchar(5000),
                                whereSqlMs varchar(5000),
                                whereSqlMy varchar(5000),
                                tblType  varchar(6),
                                syncDays varchar(6),
                                clearDays  varchar(6),
                                status  varchar(6),
                                errMessage	varchar(3000)
)$;

CREATE TABLE genTableConfig(
                               id int PRIMARY KEY,
                               tblName varchar(100),
                               genSql varchar(4000),
                               partitionCol	varchar(100),
                               queryField	varchar(1000),
                               showField	varchar(1000),
                               tableDesc	varchar(1000)
)$;


Insert into syncTableConfig values(1,'sensitive_log','id,sens_agt_id,sens_usr_id,sens_date,CONVERT(varchar, sens_time, 120) as sens_timeStr,sens_subtype,sens_info_rules,sens_info_rules_text,sens_safe_level,sens_labels_text,sens_file_name,sens_file_path as sens_file_path_all,sens_file_size,sens_msg_txt as sens_msg_txt_all,sens_forbid',
                                   'CAST(id AS SIGNED) id,CAST(sens_agt_id AS SIGNED) sens_agt_id,CAST(sens_usr_id AS SIGNED) sens_usr_id,CAST(sens_date AS SIGNED) sens_date,date_format(sens_time,''%Y-%m-%d %H:%i:%s'') AS sens_timeStr,CAST(sens_subtype AS SIGNED) sens_subtype,sens_info_rules,sens_info_rules_text,CAST(sens_safe_level AS SIGNED) sens_safe_level,sens_labels_text,sens_file_name,sens_file_path as sens_file_path_all,CAST(sens_file_size AS SIGNED) sens_file_size,sens_msg_txt as sens_msg_txt_all,CAST(sens_forbid AS SIGNED) as sens_forbid',
                                   'sens_subtype in(1,2,3,4,5,6,8)','sens_subtype in(1,2,3,4,5,6,8)','2','60','120','0')$;
Insert into genTableConfig values(1,'sensitive_log','CREATE TABLE sensitive_log (
							  uid String default concat(sens_date,lpad(toString(id), 7, ''0'')),
                              id Int64,
                              sens_agt_id Int64,
							  sens_usr_id Int64,
							  sens_date	Int64,
							  sens_timeStr String,
							  sens_time DateTime default toDateTime(sens_timeStr, ''Asia/Shanghai''),
							  sens_subtype Int64,
                              sens_forbid Int64,
                              sens_info_rules String,
                              sens_info_rules_text String,
                              sens_safe_level Int64,
                              sens_labels_text String,
                              sens_file_name String,
                              sens_file_path_all  String,
                              sens_file_path String default arrayStringConcat(arraySlice(splitByString('':'', splitByString('' ->'',sens_file_path_all)[1]), 1, 2), '':''),
							  sens_file_size Int64,
                              sens_msg_txt_all String,
                              sens_msg_txt String default  regexpExtract(sens_msg_txt_all, ''\\$\\$\\$\\$\\$\\$313\\|(.*''||char(63)||'')(\\|\\$\\$\\$\\$\\$\\$|$)'', 1)
)engine= ReplacingMergeTree()
partition by sens_date
PRIMARY KEY (sens_agt_id,sens_file_path,sens_time)
ORDER BY (sens_agt_id,sens_file_path,sens_time,sens_file_path_all,sens_subtype);','sens_date','sens_subtype|操作行为','敏感日志')$;

Insert into syncTableConfig values(2,'udisk_log','a.id,a.ud_agt_id,a.ud_usr_id,a.ud_date,CONVERT(varchar, a.ud_time, 120) as ud_timeStr,a.ud_subtype,a.ud_src_path,a.ud_dest_path,a.ud_udisk_id,a.ud_volume_sn,a.ud_udisk_encrypt_type,a.ud_desc,c.ud_cls_pname',
                                   'CAST(a.id AS SIGNED) id,CAST(a.ud_agt_id AS SIGNED) ud_agt_id,CAST(a.ud_usr_id AS SIGNED) ud_usr_id,CAST(a.ud_date AS SIGNED) ud_date,date_format(a.ud_time,''%Y-%m-%d %H:%i:%s'') AS ud_timeStr,CAST(a.ud_subtype AS SIGNED) ud_subtype,a.ud_src_path,a.ud_dest_path,a.ud_udisk_id,CAST(a.ud_volume_sn AS SIGNED) ud_volume_sn,CAST(a.ud_udisk_encrypt_type AS SIGNED) ud_udisk_encrypt_type,a.ud_desc,c.ud_cls_pname',
                                   'ud_subtype in (2,3) and ud_src_device in (0,1,6) and ud_dest_device = 4 and ud_file_type = 1','ud_subtype in (2,3) and ud_src_device in (0,1,6) and ud_dest_device = 4 and ud_file_type = 1','2','60','120','0')$;
Insert into genTableConfig values(2,'udisk_log','CREATE TABLE udisk_log (
							  uid String default concat(ud_date,lpad(toString(id), 7, ''0'')),
                              id Int64,
                              ud_agt_id Int64,
							  ud_usr_id Int64,
							  ud_date	Int64,
							  ud_timeStr String,
							  ud_time DateTime default toDateTime(ud_timeStr, ''Asia/Shanghai''),
							  ud_subtype Int64,
							  ud_src_path String,
							  ud_dest_path String,
                              ud_udisk_id String,
                              ud_volume_sn Int64,
							  ud_volume_sn_str String default concat(substring(hex(ud_volume_sn),1,4),''-'',substring(hex(ud_volume_sn),5)),
							  ud_udisk_encrypt_type Int64,
                              ud_desc String,
							  ud_cls_pname  String
)engine= ReplacingMergeTree()
partition by ud_date
PRIMARY KEY (ud_agt_id,ud_src_path,ud_time)
ORDER BY (ud_agt_id,ud_src_path,ud_time,ud_subtype);','ud_date','ud_subtype|操作行为','U盘日志')$;

Insert into syncTableConfig values(3,'policy_log','id,plc_agt_id,plc_usr_id,plc_date,CONVERT(varchar, plc_time, 120) as plc_timeStr,plc_msg_txt',
                                   'CAST(id AS SIGNED) id,CAST(plc_agt_id AS SIGNED) plc_agt_id,CAST(plc_usr_id AS SIGNED) plc_usr_id,CAST(plc_date AS SIGNED) plc_date,date_format(plc_time,''%Y-%m-%d %H:%i:%s'') AS plc_timeStr,plc_msg_txt',
                                   'plc_plc_type = 73','plc_plc_type = 73','2','60','120','0')$;
Insert into genTableConfig values(3,'policy_log','CREATE TABLE policy_log (
							  uid String default concat(plc_date,lpad(toString(id), 7, ''0'')),
                              id Int64,
                              plc_agt_id Int64,
							  plc_usr_id Int64,
							  plc_date	Int64,
							  plc_timeStr String,
							  plc_time DateTime default toDateTime(plc_timeStr, ''Asia/Shanghai''),
							  plc_msg_txt String,
							  plc_file_path String default arrayStringConcat(arraySlice(splitByString('':'', splitByString('' ->'',regexpExtract(plc_msg_txt, ''\\$\\$\\$\\$\\$\\$307\\|(.*''||char(63)||'')(\\|\\$\\$\\$\\$\\$\\$|$)'', 1))[1]), 1, 2), '':'')
)engine= ReplacingMergeTree()
partition by plc_date
PRIMARY KEY (plc_agt_id,plc_file_path,plc_time)
ORDER BY (plc_agt_id,plc_file_path,plc_time);','plc_date','','策略日志')$;



Insert into syncTableConfig values(4,'asset_change_log',
                                   'id,ac_agt_id,ac_ses_id,ac_usr_id,convert(varchar, ac_time, 120) AS ac_time,ac_date,ac_week,ac_hour,
                                   ac_type,ac_subtype,ac_cls_id,ac_src_str,ac_dest_str',
                                   'CAST(id AS SIGNED) AS id,CAST(ac_agt_id AS SIGNED) AS ac_agt_id,CAST(ac_ses_id AS SIGNED) AS ac_ses_id,
                                    CAST(ac_usr_id AS SIGNED) AS ac_usr_id,date_format(ac_time, ''%Y-%m-%d %H:%i:%s'') AS ac_time,CAST(ac_date AS SIGNED) AS ac_date,
                                    CAST(ac_week AS SIGNED) AS ac_week,CAST(ac_hour AS SIGNED) AS ac_hour,CAST(ac_type AS SIGNED) AS ac_type,CAST(ac_subtype AS SIGNED) AS ac_subtype,
                                    CAST(ac_cls_id AS SIGNED) AS ac_cls_id,ac_src_str,ac_dest_str',
                                   '','','2','60','120','0')$;






Insert into genTableConfig values(4,'asset_change_log','CREATE TABLE asset_change_log (
    id Int64,
    ac_agt_id Int64,
    ac_ses_id Int64,
    ac_usr_id Int64,
    ac_time Nullable(String),
    ac_date Int64,
    ac_week Int64,
    ac_hour Int64,
    ac_type Int64,
    ac_subtype Int64,
    ac_cls_id Int64,
    ac_src_str String,
    ac_dest_str String
)engine= ReplacingMergeTree()
partition by ac_date
PRIMARY KEY (ac_date,id)
ORDER BY (ac_date,id);','ac_date','','','')$;



Insert into syncTableConfig values(5,'decrypt_auth_request','id, dar_type, dar_agt_id, dar_usr_id, dar_ses_id, CONVERT(varchar, dar_time, 120) as dar_timeStr, dar_date, dar_week, dar_hour, dar_file_names, dar_req_detail, STUFF((
        SELECT '','' + T2.FileInfo.value(''(Size)[1]'', ''VARCHAR(50)'')
        FROM (
            SELECT CAST(CAST(dar_req_detail AS NVARCHAR(MAX)) AS XML) AS XmlData
        ) AS X
        CROSS APPLY XmlData.nodes(''/ReqDetail/FileInfo'') AS T2(FileInfo)
        FOR XML PATH(''''), TYPE
    ).value(''.'', ''NVARCHAR(MAX)''), 1, 1, '''') AS dar_file_size,dar_req_finish, dar_appr_su_id, dar_appr_su_name, dar_appr_time, dar_appr_status, dar_appr_isread, dar_appr_detail, dar_res_status, dar_res_desc, dar_res_create_auth, dar_apply, dar_apply_time, dar_delete, dar_appr_flow_id, dar_cur_status_detail, dar_cur_node_id, dar_read_info, dar_push_result, dar_push_count, dar_push_context, dar_all_appr_su, dar_cur_appr_su',
                                   'CAST(id AS SIGNED) AS id,
                                CAST(dar_type AS SIGNED) AS dar_type,
                                CAST(dar_agt_id AS SIGNED) AS dar_agt_id,
                                CAST(dar_usr_id AS SIGNED) AS dar_usr_id,
                                CAST(dar_ses_id AS SIGNED) AS dar_ses_id,
                                date_format(dar_time, ''%Y-%m-%d %H:%i:%s'') AS dar_timeStr,
                                CAST(dar_date AS SIGNED) AS dar_date,
                                CAST(dar_week AS SIGNED) AS dar_week,
                                CAST(dar_hour AS SIGNED) AS dar_hour,
                                dar_file_names,
                                dar_req_detail,
                                (
                                    SELECT GROUP_CONCAT(json_value(file_info, ''$.Size''))
                                    FROM JSON_TABLE(
                                        REPLACE(REPLACE(dar_req_detail, ''<ReqDetail>'', ''''), ''</ReqDetail>'', ''''),
                                        ''$[*]'' COLUMNS (
                                            file_info JSON PATH ''$''
                                        )
                                    ) AS jt
                                ) AS dar_file_size,
                                CAST(dar_req_finish AS SIGNED) AS dar_req_finish,
                                CAST(dar_appr_su_id AS SIGNED) AS dar_appr_su_id,
                                dar_appr_su_name,
                                date_format(dar_appr_time, ''%Y-%m-%d %H:%i:%s'') AS dar_appr_time,
                                CAST(dar_appr_status AS SIGNED) AS dar_appr_status,
                                CAST(dar_appr_isread AS SIGNED) AS dar_appr_isread,
                                dar_appr_detail,
                                CAST(dar_res_status AS SIGNED) AS dar_res_status,
                                dar_res_desc,
                                CAST(dar_res_create_auth AS SIGNED) AS dar_res_create_auth,
                                CAST(dar_apply AS SIGNED) AS dar_apply,
                                date_format(dar_apply_time, ''%Y-%m-%d %H:%i:%s'') AS dar_apply_time,
                                CAST(dar_delete AS SIGNED) AS dar_delete,
                                CAST(dar_appr_flow_id AS CHAR(36)) AS dar_appr_flow_id,
                                dar_cur_status_detail,
                                CAST(dar_cur_node_id AS SIGNED) AS dar_cur_node_id,
                                dar_read_info,
                                CAST(dar_push_result AS SIGNED) AS dar_push_result,
                                CAST(dar_push_count AS SIGNED) AS dar_push_count,
                                dar_push_context,
                                dar_all_appr_su,
                                dar_cur_appr_su','','','1','60','120','0')$;




Insert into genTableConfig values(5,'decrypt_auth_request','CREATE TABLE IF NOT EXISTS decrypt_auth_request
(
    id Int64,
    dar_type Nullable(Int64),
    dar_agt_id Nullable(Int64),
    dar_usr_id Nullable(Int64),
    dar_ses_id Nullable(Int64),
    dar_timeStr Nullable(String),
    dar_time Nullable(DateTime) default toDateTime(dar_timeStr, ''Asia/Shanghai''),
    dar_date Int64,
    dar_week Nullable(Int64),
    dar_hour Nullable(Int64),
    dar_file_names Nullable(String),
    dar_req_detail Nullable(String),
    dar_req_finish Nullable(Int64),
    dar_appr_su_id Nullable(Int64),
    dar_appr_su_name Nullable(String),
    dar_appr_time Nullable(DateTime),
    dar_appr_status Nullable(Int64),
    dar_appr_isread Nullable(Int64),
    dar_appr_detail Nullable(String),
    dar_file_size Nullable(String),
    dar_res_status Nullable(Int64),
    dar_res_desc Nullable(String),
    dar_res_create_auth Nullable(Int64),
    dar_apply Nullable(Int64),
    dar_apply_time Nullable(DateTime),
    dar_delete Nullable(Int64),
    dar_appr_flow_id Nullable(Int64),
    dar_cur_status_detail Nullable(String),
    dar_cur_node_id Nullable(Int64),
    dar_read_info Nullable(String),
    dar_push_result Nullable(Int64),
    dar_push_count Nullable(Int64),
    dar_push_context Nullable(String),
    dar_all_appr_su Nullable(String),
    dar_cur_appr_su Nullable(String)
)
    ENGINE = ReplacingMergeTree()
PRIMARY KEY id
ORDER BY (id)
PARTITION BY dar_date
SETTINGS index_granularity = 8192;','dar_date','','','解密申请表')$;


Insert into syncTableConfig values(6,'decrypt_auth_request_log','id, dar_type, dar_agt_id, dar_usr_id, dar_ses_id, CONVERT(varchar, dar_time, 120) as dar_timeStr, dar_date, dar_week, dar_hour, dar_file_names, dar_req_detail, STUFF((
        SELECT '','' + T2.FileInfo.value(''(Size)[1]'', ''VARCHAR(50)'')
        FROM (
            SELECT CAST(CAST(dar_req_detail AS NVARCHAR(MAX)) AS XML) AS XmlData
        ) AS X
        CROSS APPLY XmlData.nodes(''/ReqDetail/FileInfo'') AS T2(FileInfo)
        FOR XML PATH(''''), TYPE
    ).value(''.'', ''NVARCHAR(MAX)''), 1, 1, '''') AS dar_file_size,dar_req_finish, dar_appr_su_id, dar_appr_su_name, dar_appr_time, dar_appr_status, dar_appr_isread, dar_appr_detail, dar_res_status, dar_res_desc, dar_res_create_auth, dar_apply, dar_apply_time, dar_delete, dar_appr_flow_id, dar_all_appr_su, dar_cur_appr_su, dar_cur_status_detail, dar_cur_node_id, dar_read_info, dar_push_result, dar_push_count, dar_push_context',
                                   'CAST(id AS SIGNED) AS id,
    CAST(dar_type AS SIGNED) AS dar_type,
    CAST(dar_agt_id AS SIGNED) AS dar_agt_id,
    CAST(dar_usr_id AS SIGNED) AS dar_usr_id,
    CAST(dar_ses_id AS SIGNED) AS dar_ses_id,
    date_format(dar_time, ''%Y-%m-%d %H:%i:%s'') AS dar_timeStr,
    CAST(dar_date AS SIGNED) AS dar_date,
    CAST(dar_week AS SIGNED) AS dar_week,
    CAST(dar_hour AS SIGNED) AS dar_hour,
    dar_file_names,
    dar_req_detail,
    (
        SELECT GROUP_CONCAT(json_value(file_info, ''$.Size''))
        FROM JSON_TABLE(
            REPLACE(REPLACE(dar_req_detail, ''<ReqDetail>'', ''''), ''</ReqDetail>'', ''''),
            ''$[*]'' COLUMNS (
                file_info JSON PATH ''$''
            )
        ) AS jt
    ) AS dar_file_size,
    CAST(dar_req_finish AS SIGNED) AS dar_req_finish,
    CAST(dar_appr_su_id AS SIGNED) AS dar_appr_su_id,
    dar_appr_su_name,
    date_format(dar_appr_time, ''%Y-%m-%d %H:%i:%s'') AS dar_appr_time,
    CAST(dar_appr_status AS SIGNED) AS dar_appr_status,
    CAST(dar_appr_isread AS SIGNED) AS dar_appr_isread,
    dar_appr_detail,
    CAST(dar_res_status AS SIGNED) AS dar_res_status,
    dar_res_desc,
    CAST(dar_res_create_auth AS SIGNED) AS dar_res_create_auth,
    CAST(dar_apply AS SIGNED) AS dar_apply,
    date_format(dar_apply_time, ''%Y-%m-%d %H:%i:%s'') AS dar_apply_time,
    CAST(dar_delete AS SIGNED) AS dar_delete,
    CAST(dar_appr_flow_id AS CHAR(36)) AS dar_appr_flow_id,
    dar_cur_status_detail,
    CAST(dar_cur_node_id AS SIGNED) AS dar_cur_node_id,
    dar_read_info,
    CAST(dar_push_result AS SIGNED) AS dar_push_result,
    CAST(dar_push_count AS SIGNED) AS dar_push_count,
    dar_push_context,
    dar_all_appr_su,
    dar_cur_appr_su','','','2','60','120','0')$;

Insert into genTableConfig values(6,'decrypt_auth_request_log','CREATE TABLE IF NOT EXISTS decrypt_auth_request_log
(
    id Int64,
    dar_type Nullable(Int64),
    dar_agt_id Nullable(Int64),
    dar_usr_id Nullable(Int64),
    dar_ses_id Nullable(Int64),
    dar_timeStr Nullable(String),
    dar_time Nullable(DateTime) default toDateTime(dar_timeStr, ''Asia/Shanghai''),
    dar_date Int64,
    dar_week Nullable(Int64),
    dar_hour Nullable(Int64),
    dar_file_names Nullable(String),
    dar_req_detail Nullable(String),
    dar_req_finish Nullable(Int64),
    dar_appr_su_id Nullable(Int64),
    dar_appr_su_name Nullable(String),
    dar_appr_time Nullable(DateTime),
    dar_appr_status Nullable(Int64),
    dar_appr_isread Nullable(Int64),
    dar_appr_detail Nullable(String),
    dar_file_size Nullable(String),
    dar_res_status Nullable(Int64),
    dar_res_desc Nullable(String),
    dar_res_create_auth Nullable(Int64),
    dar_apply Nullable(Int64),
    dar_apply_time Nullable(DateTime),
    dar_delete Nullable(Int64),
    dar_appr_flow_id Nullable(Int64),
    dar_all_appr_su Nullable(String),
    dar_cur_appr_su Nullable(String),
    dar_cur_status_detail Nullable(String),
    dar_cur_node_id Nullable(Int64),
    dar_read_info Nullable(String),
    dar_push_result Nullable(Int64),
    dar_push_count Nullable(Int64),
    dar_push_context Nullable(String)
)
    ENGINE = ReplacingMergeTree()
PRIMARY KEY id
ORDER BY (id)
PARTITION BY dar_date
SETTINGS index_granularity = 8192;','dar_date','','','解密申请表日志表')$;

Insert into syncTableConfig values(7,'approval_flow','id, af_id, af_name','CAST(id AS SIGNED) AS id, CAST(af_id AS SIGNED) AS af_id , af_name','','','1','60','120','0')$;

Insert into genTableConfig values(7,'approval_flow','CREATE TABLE IF NOT EXISTS approval_flow
(
    id Int64,
    af_id Int64,
    af_name String
)
    ENGINE = ReplacingMergeTree()
PRIMARY KEY af_id
ORDER BY (af_id)
SETTINGS index_granularity = 8192;','','','','流程管理表')$;

INSERT INTO syncTableConfig VALUES (8, 'common_approval_flow', 'id,CONVERT(varchar, caf_id, 36) as caf_id,caf_name',
                                    'id,CAST(caf_id AS CHAR(36)) AS caf_id,caf_name', '','','1', '60', '120', '0', '')$;

INSERT INTO gentableconfig VALUES (8, 'common_approval_flow', e'CREATE TABLE common_approval_flow (
                              id Int64,
                              caf_id String,
                              caf_name String
)engine= ReplacingMergeTree() PRIMARY KEY caf_id;', '', '', '', '流程基础数据')$;


INSERT INTO synctableconfig VALUES (10, 'auth_request', 'id,
   ar_request_type,
   ar_agt_id,
   ar_usr_id,
   ar_ses_id,
   CONVERT(varchar, ar_time, 120) as ar_timeStr,
   ar_date,
   ar_req_detail,
   ar_req_detail_init,
   ar_all_appr_su,
   ar_cur_appr_su,
   CONVERT(varchar, ar_appr_time, 120) as ar_appr_timeStr,
   ar_appr_status,
   ar_appr_isread,
   ar_appr_detail,
   CAST(ar_appr_flow_id AS VARCHAR(36)) as ar_appr_flow_id,
   ar_res_status,
   ar_res_desc,
   ar_res_create_auth,
   ar_apply,
    CONVERT(varchar, ar_apply_time, 120) as ar_apply_timeStr,
    ar_exec,
    CONVERT(varchar, ar_exec_begin, 120) as ar_exec_beginStr,
    CONVERT(varchar, ar_exec_end, 120) as ar_exec_endStr,
   ar_auto_exec,
   ar_delete,
   ar_read_info,
   ar_push_result,
   ar_push_count,
   ar_push_context',
                                    'CAST(id AS SIGNED) AS id,
                                CAST(ar_request_type AS SIGNED) AS ar_request_type,
                                CAST(ar_agt_id AS SIGNED) AS ar_agt_id,
                                CAST(ar_usr_id AS SIGNED) AS ar_usr_id,
                                CAST(ar_ses_id AS SIGNED) AS ar_ses_id,
                                date_format(ar_time, ''%Y-%m-%d %H:%i:%s'') AS ar_timeStr,
                                CAST(ar_date AS SIGNED) AS ar_date,
                                ar_req_detail,
                                ar_req_detail_init,
                                ar_all_appr_su,
                                ar_cur_appr_su,
                                date_format(ar_appr_time, ''%Y-%m-%d %H:%i:%s'') AS ar_appr_timeStr,
                                CAST(ar_appr_status AS SIGNED) AS ar_appr_status,
                                CAST(ar_appr_flow_id AS CHAR(36)) AS ar_appr_flow_id,
                                CAST(ar_appr_isread AS SIGNED) AS ar_appr_isread,
                                ar_appr_detail,
                                CAST(ar_res_status AS SIGNED) AS ar_res_status,
                                ar_res_desc,
                                CAST(ar_res_create_auth AS SIGNED) AS ar_res_create_auth,
                                CAST(ar_apply AS SIGNED) AS ar_apply,
                                date_format(ar_apply_time, ''%Y-%m-%d %H:%i:%s'') AS ar_apply_timeStr,
                                CAST(ar_exec AS SIGNED) AS ar_exec,
                                date_format(ar_exec_begin, ''%Y-%m-%d %H:%i:%s'') AS ar_exec_beginStr,
                                date_format(ar_exec_end, ''%Y-%m-%d %H:%i:%s'') AS ar_exec_endStr,
                                CAST(ar_auto_exec AS SIGNED) AS ar_auto_exec,
                                CAST(ar_delete AS SIGNED) AS ar_delete,
                                ar_read_info,
                                CAST(ar_push_result AS SIGNED) AS ar_push_result,
                                CAST(ar_push_count AS SIGNED) AS ar_push_count,
                                ar_push_context','ar_request_type in (14,16)','ar_request_type in (14,16)', '1', '60', '120', '0', '')$;

INSERT INTO public.gentableconfig (id, tblname, gensql, partitioncol, queryfield, showfield, tabledesc) VALUES (10, 'auth_request', e'CREATE TABLE auth_request (
     id Int64,
     ar_request_type Int64,
     ar_history Int64,
     ar_online Int64,
     ar_agt_id Int64,
     ar_usr_id Int64,
     ar_ses_id Int64,
     ar_appr_flow_id String,
     ar_timeStr String,
     ar_time DateTime default toDateTime(ar_timeStr, \'Asia/Shanghai\'),
     ar_date Int64,
     ar_week Int64,
     ar_hour Int64,
     ar_req_detail String,
     ar_req_detail_init String,
     ar_all_appr_su String,
     ar_cur_appr_su String,
     ar_appr_timeStr String,
     ar_appr_time DateTime default toDateTime(ar_appr_timeStr, \'Asia/Shanghai\'),
     ar_appr_status Int64,
     ar_appr_isread Int64,
     ar_appr_detail String,
     ar_res_status Int64,
     ar_res_desc String,
     ar_res_create_auth Int64,
     ar_apply Int64,
     ar_apply_timeStr String,
     ar_apply_time DateTime default toDateTime(ar_apply_timeStr, \'Asia/Shanghai\'),
     ar_exec Int64,
     ar_exec_beginStr String,
     ar_exec_begin  Nullable(DateTime) DEFAULT toDateTime(nullIf(ar_exec_beginStr, \'\'), \'Asia/Shanghai\'),
     ar_exec_endStr String,
     ar_exec_end  Nullable(DateTime) DEFAULT toDateTime(nullIf(ar_exec_endStr, \'\'), \'Asia/Shanghai\'),
     ar_auto_exec Int64,
     ar_delete Int64,
     ar_read_info String,
     ar_push_result Int64,
     ar_push_count Int64,
     ar_push_context String,
    extracted_path String MATERIALIZED if(
        position(ar_req_detail, \'<Path>\') > 0 AND position(ar_req_detail, \'</Path>\') > position(ar_req_detail, \'<Path>\'),
        substring(
            ar_req_detail,
            position(ar_req_detail, \'<Path>\') + length(\'<Path>\'),
            position(ar_req_detail, \'</Path>\') - position(ar_req_detail, \'<Path>\') - length(\'<Path>\')
        ),
        \'\'
    ),
    extracted_size String MATERIALIZED if(
        position(ar_req_detail, \'<Size>\') > 0
        AND position(ar_req_detail, \'</Size>\') > position(ar_req_detail, \'<Size>\'),
        substring(
            ar_req_detail,
            position(ar_req_detail, \'<Size>\') + length(\'<Size>\'),
            position(ar_req_detail, \'</Size>\') - position(ar_req_detail, \'<Size>\') - length(\'<Size>\')
        ),
        \'\'
    )
  )
  ENGINE = MergeTree()
  PARTITION BY ar_date
  PRIMARY KEY (ar_date, id)
  ORDER BY (ar_date, id)
', 'ar_date', '', '', '')$;


INSERT INTO synctableconfig VALUES (9, 'auth_request_log', 'id,
    ar_request_type,
    ar_agt_id,
    ar_usr_id,
    ar_ses_id,
    CONVERT(varchar, ar_time, 120) as ar_timeStr,
    ar_date,
    ar_req_detail,
    ar_req_detail_init,
    ar_all_appr_su,
    ar_cur_appr_su,
    CONVERT(varchar, ar_appr_time, 120) as ar_appr_timeStr,
    ar_appr_status,
    CAST(ar_appr_flow_id AS VARCHAR(36)) as ar_appr_flow_id,
    ar_appr_isread,
    ar_appr_detail,
    ar_res_status,
    ar_res_desc,
    ar_res_create_auth,
    ar_apply,
    CONVERT(varchar, ar_apply_time, 120) as ar_apply_timeStr,
    ar_exec,
    CONVERT(varchar, ar_exec_begin, 120) as ar_exec_beginStr,
    CONVERT(varchar, ar_exec_end, 120) as ar_exec_endStr,
    ar_auto_exec,
    ar_delete,
    ar_read_info,
    ar_push_result,
    ar_push_count,
   ar_push_context',
                                    'CAST(id AS SIGNED) AS id,
                                    CAST(ar_request_type AS SIGNED) AS ar_request_type,
                                    CAST(ar_agt_id AS SIGNED) AS ar_agt_id,
                                    CAST(ar_usr_id AS SIGNED) AS ar_usr_id,
                                    CAST(ar_ses_id AS SIGNED) AS ar_ses_id,
                                    date_format(ar_time, ''%Y-%m-%d %H:%i:%s'') AS ar_timeStr,
                                    CAST(ar_date AS SIGNED) AS ar_date,
                                    ar_req_detail,
                                    ar_req_detail_init,
                                    ar_all_appr_su,
                                    ar_cur_appr_su,
                                    date_format(ar_appr_time, ''%Y-%m-%d %H:%i:%s'') AS ar_appr_timeStr,
                                    CAST(ar_appr_status AS SIGNED) AS ar_appr_status,
                                    CAST(ar_appr_flow_id AS CHAR(36)) AS ar_appr_flow_id,
                                    CAST(ar_appr_isread AS SIGNED) AS ar_appr_isread,
                                    ar_appr_detail,
                                    CAST(ar_res_status AS SIGNED) AS ar_res_status,
                                    ar_res_desc,
                                    CAST(ar_res_create_auth AS SIGNED) AS ar_res_create_auth,
                                    CAST(ar_apply AS SIGNED) AS ar_apply,
                                    date_format(ar_apply_time, ''%Y-%m-%d %H:%i:%s'') AS ar_apply_timeStr,
                                    CAST(ar_exec AS SIGNED) AS ar_exec,
                                    date_format(ar_exec_begin, ''%Y-%m-%d %H:%i:%s'') AS ar_exec_beginStr,
                                    date_format(ar_exec_end, ''%Y-%m-%d %H:%i:%s'') AS ar_exec_endStr,
                                    CAST(ar_auto_exec AS SIGNED) AS ar_auto_exec,
                                    CAST(ar_delete AS SIGNED) AS ar_delete,
                                    ar_read_info,
                                    CAST(ar_push_result AS SIGNED) AS ar_push_result,
                                    CAST(ar_push_count AS SIGNED) AS ar_push_count,
                                    ar_push_context','ar_request_type in (14,16)','ar_request_type in (14,16)', '2', '60', '120', '0', '')$;


INSERT INTO public.gentableconfig (id, tblname, gensql, partitioncol, queryfield, showfield, tabledesc) VALUES (9, 'auth_request_log', e'CREATE TABLE auth_request_log (
     id Int64,
     ar_request_type Int64,
     ar_history Int64,
     ar_online Int64,
     ar_agt_id Int64,
     ar_usr_id Int64,
     ar_ses_id Int64,
     ar_timeStr String,
     ar_time DateTime default toDateTime(ar_timeStr, \'Asia/Shanghai\'),
     ar_date Int64,
     ar_week Int64,
     ar_hour Int64,
     ar_req_detail String,
     ar_appr_flow_id String,  ar_req_detail_init String,
     ar_all_appr_su String,
     ar_cur_appr_su String,
     ar_appr_timeStr String,
     ar_appr_time DateTime default toDateTime(ar_appr_timeStr, \'Asia/Shanghai\'),
     ar_appr_status Int64,
     ar_appr_isread Int64,
     ar_appr_detail String,
     ar_res_status Int64,
     ar_res_desc String,
     ar_res_create_auth Int64,
     ar_apply Int64,
     ar_apply_timeStr String,
     ar_apply_time DateTime default toDateTime(ar_apply_timeStr, \'Asia/Shanghai\'),
     ar_exec Int64,
     ar_exec_beginStr String,
     ar_exec_begin  Nullable(DateTime) DEFAULT toDateTime(nullIf(ar_exec_beginStr, \'\'), \'Asia/Shanghai\'),
     ar_exec_endStr String,
     ar_exec_end  Nullable(DateTime) DEFAULT toDateTime(nullIf(ar_exec_endStr, \'\'), \'Asia/Shanghai\'),
     ar_auto_exec Int64,
     ar_delete Int64,
     ar_read_info String,
     ar_push_result Int64,
     ar_push_count Int64,
     ar_push_context String,
    extracted_path String MATERIALIZED if(
        position(ar_req_detail, \'<Path>\') > 0 AND position(ar_req_detail, \'</Path>\') > position(ar_req_detail, \'<Path>\'),
        substring(
            ar_req_detail,
            position(ar_req_detail, \'<Path>\') + length(\'<Path>\'),
            position(ar_req_detail, \'</Path>\') - position(ar_req_detail, \'<Path>\') - length(\'<Path>\')
        ),
        \'\'
    ),
    extracted_size String MATERIALIZED if(
        position(ar_req_detail, \'<Size>\') > 0
        AND position(ar_req_detail, \'</Size>\') > position(ar_req_detail, \'<Size>\'),
        substring(
            ar_req_detail,
            position(ar_req_detail, \'<Size>\') + length(\'<Size>\'),
            position(ar_req_detail, \'</Size>\') - position(ar_req_detail, \'<Size>\') - length(\'<Size>\')
        ),
        \'\'
    )
  )
  ENGINE = MergeTree()
  PARTITION BY ar_date
  PRIMARY KEY (ar_date, id)
  ORDER BY (ar_date, id)
', 'ar_date', '', '', '')$;


Insert into syncTableConfig values
    (11,'doc_labels_log','id,dlbs_agt_id,dlbs_ses_id,dlbs_usr_id,CONVERT(varchar, dlbs_time, 120) as dlbs_timeStr,dlbs_date,dlbs_subtype,dlbs_labels,dlbs_labels_text,dlbs_file_name,dlbs_file_path,dlbs_docnum,dlbs_file_size,dlbs_safe_level,dlbs_app_hash,dlbs_app_title',
     'CAST(id AS SIGNED) id,CAST(dlbs_agt_id AS SIGNED) dlbs_agt_id,CAST(dlbs_ses_id AS SIGNED) dlbs_ses_id,CAST(dlbs_usr_id AS SIGNED) dlbs_usr_id,CAST(dlbs_date AS SIGNED) dlbs_date,date_format(dlbs_time,''%Y-%m-%d %H:%i:%s'') AS dlbs_timeStr,CAST(dlbs_subtype AS SIGNED) dlbs_subtype,dlbs_labels,dlbs_labels_text,dlbs_file_name,
dlbs_file_path,dlbs_docnum,CAST(dlbs_file_size AS SIGNED) dlbs_file_size,CAST(dlbs_safe_level AS SIGNED) dlbs_safe_level,dlbs_app_hash,dlbs_app_title','','','2','60','120','0')$;


Insert into genTableConfig values(11,'doc_labels_log','CREATE TABLE doc_labels_log (
                              uid String default concat(dlbs_date,lpad(toString(id), 7, ''0'')),
                              id Int64,
                              dlbs_agt_id Int64,
                              dlbs_ses_id Int64,
                              dlbs_usr_id Int64,
                              dlbs_date   Int64,
                              dlbs_timeStr String,
                              dlbs_time DateTime default toDateTime(dlbs_timeStr, ''Asia/Shanghai''),
                              dlbs_subtype   Int64,
                              dlbs_labels String,
                              dlbs_labels_text String,
                              dlbs_file_name String,
                              dlbs_file_path String,
                              dlbs_docnum String,
                              dlbs_file_size Int64,
                              dlbs_safe_level Int64,
                              dlbs_app_hash String,
                              dlbs_app_title String
)engine= ReplacingMergeTree()
partition by dlbs_date
PRIMARY KEY (dlbs_agt_id,dlbs_file_path,dlbs_time)
ORDER BY (dlbs_agt_id,dlbs_file_path,dlbs_time,dlbs_subtype);','dlbs_date','','dlbs_subtype|操作行为','文档标签日志')$;



create table download_source
(
    ds_id       serial,
    ds_name     varchar(50),
    ds_type     integer,
    update_time timestamp,
    value       varchar(20480),
    desc_info   varchar(20480)
)$;

INSERT INTO download_source (ds_id, ds_name, ds_type, update_time, value, desc_info) VALUES (-100001, '其他', -1, null, null, null)$;

create table download_filter
(
    df_id       serial
        primary key,
    df_name     varchar(50),
    status      integer,
    update_time timestamp,
    value       varchar(20480),
    add_type    integer,
    restore_id  integer,
    is_default  boolean,
    act       integer
)$;

INSERT INTO download_filter(df_id, df_name, status, update_time, value, add_type, restore_id, is_default, act) VALUES (3001, '企业微信截图文件过滤', 1, null, '{"is_leaf":false,"relation":1,"next":[{"is_leaf":true,"relation":0,"next":[],"data":{"filterType":1211,"compare":1,"value":"10","value2":"","unit":0,"unit2":0}},{"is_leaf":true,"relation":0,"next":[],"data":{"filterType":1323,"compare":3,"value":"\\cache\\","value2":"","unit":0,"unit2":0}},{"is_leaf":true,"data":{"compare":3,"filterType":1313,"value":"企业微信截图_"}}]}', 1, -3001, false, 1)$;
INSERT INTO download_filter(df_id, df_name, status, update_time, value, add_type, restore_id, is_default, act) VALUES (-3001, '企业微信截图文件过滤', 1, null, '{"is_leaf":false,"relation":1,"next":[{"is_leaf":true,"relation":0,"next":[],"data":{"filterType":1211,"compare":1,"value":"10","value2":"","unit":0,"unit2":0}},{"is_leaf":true,"relation":0,"next":[],"data":{"filterType":1323,"compare":3,"value":"\\cache\\","value2":"","unit":0,"unit2":0}},{"is_leaf":true,"data":{"compare":3,"filterType":1313,"value":"企业微信截图_"}}]}', 1, 0, false, 1)$;
INSERT INTO download_filter(df_id, df_name, status, update_time, value, add_type, restore_id, is_default, act) VALUES (3002, '0kb过滤', 1, null, '{"is_leaf":true,"data":{"compare":1,"filterType":1317,"value":"0","unit":2},"next":[]}', 1, -3002, false, 1)$;
INSERT INTO download_filter(df_id, df_name, status, update_time, value, add_type, restore_id, is_default, act) VALUES (-3002, '0kb过滤', 1, null, '{"is_leaf":true,"data":{"compare":1,"filterType":1317,"value":"0","unit":2},"next":[]}', 1, 0, false, 1)$;
INSERT INTO download_filter(df_id, df_name, status, update_time, value, add_type, restore_id, is_default, act) VALUES (3003, 'cache缓存文件过滤', 1, null, '{"is_leaf":false,"next":[{"is_leaf":true,"data":{"compare":1,"filterType":1211,"value":"10"},"relation":1,"next":[]},{"is_leaf":false,"relation":2,"next":[{"is_leaf":true,"data":{"compare":1,"filterType":1314,"value":"jpg"}},{"is_leaf":true,"data":{"filterType":1314,"compare":1,"value":"png","value2":[],"unit":0}}]},{"is_leaf":true,"data":{"compare":3,"filterType":1323,"value":"\\cache\\","value2":[],"unit":0}}],"relation":1}', 1, -3003, false, 1)$;
INSERT INTO download_filter(df_id, df_name, status, update_time, value, add_type, restore_id, is_default, act) VALUES (-3003, 'cache缓存文件过滤', 1, null, '{"is_leaf":false,"next":[{"is_leaf":true,"data":{"compare":1,"filterType":1211,"value":"10"},"relation":1,"next":[]},{"is_leaf":false,"relation":2,"next":[{"is_leaf":true,"data":{"compare":1,"filterType":1314,"value":"jpg"}},{"is_leaf":true,"data":{"filterType":1314,"compare":1,"value":"png","value2":[],"unit":0}}]},{"is_leaf":true,"data":{"compare":3,"filterType":1323,"value":"\\cache\\","value2":[],"unit":0}}],"relation":1}', 1, 0, false, 1)$;


--- 金发二期
ALTER TABLE software
    ADD COLUMN expiration date DEFAULT '2000-01-01'$;

CREATE TABLE soft_filter_risk (
                                  item_id SERIAL PRIMARY KEY,
                                  obj_ids TEXT,
                                  obj_names TEXT,
                                  value TEXT,
                                  softwares VARCHAR(648)
)$;


CREATE TABLE soft_filter_risk_flat (
                                       item_id INTEGER,
                                       agt_id INTEGER,
                                       agt_grp_id INTEGER,
                                       software VARCHAR(160)
)$;


CREATE TABLE soft_filter_play (
                                  item_id SERIAL PRIMARY KEY,
                                  obj_ids TEXT,
                                  obj_names TEXT,
                                  value TEXT,
                                  softwares VARCHAR(648)
)$;


CREATE TABLE soft_filter_play_flat (
                                       item_id INTEGER,
                                       agt_id INTEGER,
                                       agt_grp_id INTEGER,
                                       software VARCHAR(160)
)$;

INSERT INTO soft_classification ("id", "pid", "name", "icon", "desc") VALUES
                                                                          (51, 0, '游戏软件', 'fa-th-large', ''),
                                                                          (52, 0, '娱乐软件', 'fa-th-large', ''),
                                                                          (53, 0, '炒股软件', 'fa-th-large', ''),
                                                                          (54, 0, '来源不明', 'fa-th-large', ''),
                                                                          (55, 0, '穿透软件', 'fa-th-large', '')$;
SELECT setval('soft_classification_id_seq', 59, true)$;
DROP TABLE IF EXISTS soft_cate_black$;
CREATE TABLE soft_cate_black (
                                 "id" serial PRIMARY KEY,
                                 "software_type" varchar NOT NULL,
                                 "cid" int4 NOT NULL
)$;
DROP TABLE IF EXISTS soft_statistic_config$;

CREATE TABLE soft_statistic_config (
                                       "config_id" serial PRIMARY KEY,
                                       "type" int4 NOT NULL,
                                       "name" varchar NOT NULL,
                                       "rule" varchar(3000),
                                       "status" int4,
                                       "update_time" timestamp,
                                       "is_system" int4
)$;
INSERT INTO "public"."soft_statistic_config" VALUES (1, 1, '非工作软件', '{"is_leaf":true,"data":{"compare":1,"filterType":1555,"value":"51,52,53"},"next":[]}', 1, NOW(), 1)$;
INSERT INTO "public"."soft_statistic_config" VALUES (2, 1, '风险软件', '{"is_leaf":true,"data":{"compare":1,"filterType":1555,"value":"54,55"},"next":[]}', 1, NOW(), 1)$;
INSERT INTO "public"."soft_statistic_config" VALUES (3, 2, '闲置', '{"compare":5,"value":30,"value2":1}', 0, NOW(), 0)$;
INSERT INTO "public"."soft_statistic_config" VALUES (4, 2, '正常', '{"compare":6,"value":30,"value2":80}', 0, NOW(), 0)$;
INSERT INTO "public"."soft_statistic_config" VALUES (5, 2, '濒临', '{"compare":6,"value":80,"value2":100}', 0, NOW(), 0)$;
INSERT INTO "public"."soft_statistic_config" VALUES (6, 2, '即将过期', '{"compare":5,"value":30,"value2":0}', 0, NOW(), 0)$;


DELETE FROM type_process_ref
WHERE ctid IN (
    SELECT ctid
    FROM type_process_ref
    WHERE software_type = 'Adobe Acrobat'
      AND process_name = 'ADNotificationManager.exe'
      AND iseffect = '1'
      AND level = '4'
    LIMIT 1
)$;
DELETE FROM type_process_ref
WHERE ctid IN (
    SELECT ctid
    FROM type_process_ref
    WHERE software_type = 'Adobe Acrobat'
      AND process_name = 'Acrobat.exe'
      AND iseffect = '1'
      AND level = '4'
    LIMIT 1
)$;
ALTER TABLE type_process_ref
    ADD CONSTRAINT uk_type_process_ref_st_pn UNIQUE (software_type, process_name)$;
ALTER TABLE soft_classification
    ADD CONSTRAINT uk_soft_classification_name UNIQUE (name)$;
ALTER TABLE black_softname_type_ref_vague
    ADD CONSTRAINT uk_black_softname_type_ref_vague_sn_st UNIQUE (software_name, software_type)$;
ALTER TABLE softname_type_ref_vague
    ADD CONSTRAINT uk_softname_type_ref_vague_sn_st UNIQUE (software_name, software_type)$;
ALTER TABLE soft_cate_ref
    ADD CONSTRAINT uk_soft_cate_ref_st_cid UNIQUE (software_type, cid)$;
ALTER TABLE softname_type_ref
    ADD CONSTRAINT uk_softname_type_ref_sn_st UNIQUE (software_name, software_type)$;

DROP TABLE IF EXISTS "public"."soft_version"$;
CREATE TABLE "public"."soft_version" (
                                         "id" int4 NOT NULL,
                                         "version" varchar(255) COLLATE "pg_catalog"."default",
                                         "update" timestamp(6)
)$;

CREATE TABLE install_cate_ref (
                                  install_package_name varchar(255) DEFAULT NULL,
                                  cid int2 DEFAULT null
)$;
ALTER TABLE install_cate_ref ADD CONSTRAINT install_cid_key UNIQUE (install_package_name,cid)$;

-- ----------------------------
-- Primary Key structure for table soft_version
-- ----------------------------
ALTER TABLE "public"."soft_version" ADD CONSTRAINT "soft_version_pkey" PRIMARY KEY ("id")$;

INSERT INTO "public"."soft_version" VALUES (1, '1.0', NOW())$;


CREATE TABLE must_install_soft (
                                   item_id SERIAL PRIMARY KEY,
                                   obj_ids TEXT,
                                   obj_names TEXT,
                                   value TEXT,
                                   softwares TEXT
)$;

CREATE TABLE must_install_soft_temp (
                                        item_id SERIAL PRIMARY KEY,
                                        obj_ids TEXT,
                                        obj_names TEXT,
                                        value TEXT,
                                        softwares VARCHAR(648)
)$;

CREATE TABLE must_install_soft_flat (
                                        item_id INTEGER,
                                        agt_id INTEGER,
                                        agt_grp_id INTEGER,
                                        software VARCHAR(64)
)$;


CREATE TABLE "public"."sync_daily" (
                                       "appdate" varchar(10) COLLATE "pg_catalog"."default" NOT NULL,
                                       "type" varchar(50) COLLATE "pg_catalog"."default" NOT NULL,
                                       "id" int4,
                                       "count" int4 NOT NULL DEFAULT 0,
                                       CONSTRAINT "sync_daily_pkey" PRIMARY KEY ("appdate", "type")
)$;
COMMENT ON COLUMN "public"."sync_daily"."appdate" IS '数据日期，格式为 YYYMMDD'$;
COMMENT ON COLUMN "public"."sync_daily"."type" IS '同步类型'$;
COMMENT ON COLUMN "public"."sync_daily"."id" IS '每日同步的id最大值'$;
COMMENT ON COLUMN "public"."sync_daily"."count" IS '同步数量'$;
COMMENT ON TABLE "public"."sync_daily" IS '每日同步数据状态记录表'$;

-- ----------------------------
-- Indexes structure for table sync_daily
-- ----------------------------
CREATE INDEX "idx_sync_daily_appdate_type" ON "public"."sync_daily" USING btree (
  "appdate" COLLATE "pg_catalog"."default" "pg_catalog"."text_ops" ASC NULLS LAST,
  "type" COLLATE "pg_catalog"."default" "pg_catalog"."text_ops" ASC NULLS LAST
)$;


CREATE TABLE "public"."install_package_white" (
                                                  "id" int4 NOT NULL,
                                                  "ip_name" varchar(255) COLLATE "pg_catalog"."default",
                                                  "ip_type" varchar(255) COLLATE "pg_catalog"."default"
)$;
COMMENT ON COLUMN "public"."install_package_white"."ip_name" IS '安装包名称'$;
COMMENT ON COLUMN "public"."install_package_white"."ip_type" IS '安装包类型'$;

-- Primary Key structure for table install_package_white
-- ----------------------------
ALTER TABLE "public"."install_package_white" ADD CONSTRAINT "install_package_white_pkey" PRIMARY KEY ("id")$;


CREATE TABLE high_install_soft (
    software VARCHAR(648)
)$;

CREATE TABLE high_install_soft_temp(
    software TEXT
)$;


create table doc_care
(
    id     serial
        primary key,
    sensitive_id varchar(50),
    name         varchar(255),
    type         integer,
    add_time timestamp
)$;


create view doc_care_view
            (name)
as
SELECT lower(name)
FROM doc_care
WHERE type = 1$;

create view doc_care_no_view
            (name)
as
SELECT lower(name)
FROM doc_care
WHERE type = 2$;

create view doc_care_sens_view
            (sensitive_id)
as
SELECT lower(sensitive_id)
FROM doc_care
WHERE type = 3$;

create table if not exists legal_act
(
    id          serial
    primary key,
    act_name    varchar(50),
    act_type    integer not null,
    act_value   text,
    status      integer,
    update_time timestamp
)$;
