truncate table genTableConfig$;

INSERT INTO public.gentableconfig (id, tblname, gensql, partitioncol, queryfield, showfield, tabledesc) VALUES (1, 'sensitive_log', e'CREATE TABLE sensitive_log (
							  uid String default concat(sens_date,lpad(toString(id), 7, \'0\')),
                              id Int64,
                              sens_agt_id Int64,
							  sens_usr_id Int64,
							  sens_date	Int64,
							  sens_timeStr String,
							  sens_time DateTime default toDateTime(sens_timeStr, \'Asia/Shanghai\'),
							  sens_subtype Int64,
                              sens_forbid Int64,
                              sens_info_rules String,
                              sens_info_rules_text String,
                              sens_safe_level Int64,
                              sens_labels_text String,
                              sens_file_name String,
                              sens_file_path_all  String,
                              sens_file_path String default arrayStringConcat(arraySlice(splitByString(\':\', splitByString(\' ->\',sens_file_path_all)[1]), 1, 2), \':\'),
							  sens_file_size Int64,
                              sens_msg_txt_all String,
                              sens_msg_txt String default  regexpExtract(sens_msg_txt_all, \'\\\\$\\\\$\\\\$\\\\$\\\\$\\\\$313\\\\|(.*\'||char(63)||\')(\\\\|\\\\$\\\\$\\\\$\\\\$\\\\$\\\\$|$)\', 1)
)engine= ReplacingMergeTree()
partition by sens_date
PRIMARY KEY (sens_agt_id,sens_file_path,sens_time)
ORDER BY (sens_agt_id,sens_file_path,sens_time,sens_file_path_all,sens_subtype)', 'sens_date', 'sens_subtype|操作行为', '敏感日志', null)$;
INSERT INTO public.gentableconfig (id, tblname, gensql, partitioncol, queryfield, showfield, tabledesc) VALUES (2, 'udisk_log', e'CREATE TABLE udisk_log (
							  uid String default concat(ud_date,lpad(toString(id), 7, \'0\')),
                              id Int64,
                              ud_agt_id Int64,
							  ud_usr_id Int64,
							  ud_date	Int64,
							  ud_timeStr String,
							  ud_time DateTime default toDateTime(ud_timeStr, \'Asia/Shanghai\'),
							  ud_subtype Int64,
							  ud_src_path String,
							  ud_dest_path String,
                              ud_udisk_id String,
                              ud_volume_sn Int64,
							  ud_volume_sn_str String default if(ud_volume_sn=0,\'0000-0000\',concat(substring(hex(ud_volume_sn),1,4),\'-\',substring(hex(ud_volume_sn),5))),
							  ud_udisk_encrypt_type Int64,
                              ud_desc String,
							  ud_cls_pname  String,
							  ud_file_size Int64,
)engine= ReplacingMergeTree()
partition by ud_date
PRIMARY KEY (ud_agt_id,ud_src_path,ud_time)
ORDER BY (ud_agt_id,ud_src_path,ud_time,ud_subtype,ud_udisk_id)', 'ud_date', 'ud_subtype|操作行为', 'U盘日志', null)$;
INSERT INTO public.gentableconfig (id, tblname, gensql, partitioncol, queryfield, showfield, tabledesc) VALUES (3, 'policy_log', e'CREATE TABLE policy_log (
							  uid String default concat(plc_date,lpad(toString(id), 7, \'0\')),
                              id Int64,
                              plc_agt_id Int64,
							  plc_usr_id Int64,
							  plc_date	Int64,
							  plc_timeStr String,
							  plc_time DateTime default toDateTime(plc_timeStr, \'Asia/Shanghai\'),
							  plc_msg_txt String,
							  plc_file_path String default arrayStringConcat(arraySlice(splitByString(\':\', splitByString(\' ->\',regexpExtract(plc_msg_txt, \'\\\\$\\\\$\\\\$\\\\$\\\\$\\\\$307\\\\|(.*\'||char(63)||\')(\\\\|\\\\$\\\\$\\\\$\\\\$\\\\$\\\\$|$)\', 1))[1]), 1, 2), \':\')
)engine= ReplacingMergeTree()
partition by plc_date
PRIMARY KEY (plc_agt_id,plc_file_path,plc_time)
ORDER BY (plc_agt_id,plc_file_path,plc_time)', 'plc_date', '', '策略日志', null)$;
INSERT INTO public.gentableconfig (id, tblname, gensql, partitioncol, queryfield, showfield, tabledesc) VALUES (4, 'asset_change_log', e'CREATE TABLE asset_change_log (
    id Int64,
    ac_agt_id Int64,
    ac_ses_id Int64,
    ac_usr_id Int64,
    ac_time Nullable(String),
    ac_date Int64,
    ac_week Int64,
    ac_hour Int64,
    ac_type Int64,
    ac_subtype Int64,
    ac_cls_id Int64,
    ac_src_str String,
    ac_dest_str String
)engine= ReplacingMergeTree()
partition by ac_date
PRIMARY KEY (ac_date,id)
ORDER BY (ac_date,id)', 'ac_date', '', '', '')$;
INSERT INTO public.gentableconfig (id, tblname, gensql, partitioncol, queryfield, showfield, tabledesc) VALUES (5, 'decrypt_auth_request', e'CREATE TABLE IF NOT EXISTS decrypt_auth_request
(
    id Int64,
    dar_type Nullable(Int64),
    dar_agt_id Nullable(Int64),
    dar_usr_id Nullable(Int64),
    dar_ses_id Nullable(Int64),
    dar_timeStr Nullable(String),
    dar_time Nullable(DateTime) default toDateTime(dar_timeStr, \'Asia/Shanghai\'),
    dar_date Int64,
    dar_week Nullable(Int64),
    dar_hour Nullable(Int64),
    dar_file_names Nullable(String),
    dar_req_detail Nullable(String),
    dar_req_finish Nullable(Int64),
    dar_appr_su_id Nullable(Int64),
    dar_appr_su_name Nullable(String),
    dar_appr_timeStr Nullable(String),
    dar_appr_time Nullable(DateTime) default toDateTime(dar_appr_timeStr, \'Asia/Shanghai\'),
    dar_appr_status Nullable(Int64),
    dar_appr_isread Nullable(Int64),
    dar_appr_detail Nullable(String),
    dar_file_size Nullable(String),
    dar_res_status Nullable(Int64),
    dar_res_desc Nullable(String),
    dar_res_create_auth Nullable(Int64),
    dar_apply Nullable(Int64),
    dar_apply_timeStr Nullable(String),
    dar_apply_time Nullable(DateTime) default toDateTime(dar_apply_timeStr, \'Asia/Shanghai\'),
    dar_delete Nullable(Int64),
    dar_appr_flow_id Nullable(Int64),
    dar_cur_status_detail Nullable(String),
    dar_cur_node_id Nullable(Int64),
    dar_read_info Nullable(String),
    dar_push_result Nullable(Int64),
    dar_push_count Nullable(Int64),
    dar_push_context Nullable(String),
    dar_all_appr_su Nullable(String),
    dar_cur_appr_su Nullable(String)
)
    ENGINE = ReplacingMergeTree()
PRIMARY KEY id
ORDER BY (id)
PARTITION BY dar_date
SETTINGS index_granularity = 8192;', 'dar_date', '', '', '解密申请表')$;
INSERT INTO public.gentableconfig (id, tblname, gensql, partitioncol, queryfield, showfield, tabledesc) VALUES (6, 'decrypt_auth_request_log', e'CREATE TABLE IF NOT EXISTS decrypt_auth_request_log
(
    id Int64,
    dar_type Nullable(Int64),
    dar_agt_id Nullable(Int64),
    dar_usr_id Nullable(Int64),
    dar_ses_id Nullable(Int64),
    dar_timeStr Nullable(String),
    dar_time Nullable(DateTime) default toDateTime(dar_timeStr, \'Asia/Shanghai\'),
    dar_date Int64,
    dar_week Nullable(Int64),
    dar_hour Nullable(Int64),
    dar_file_names Nullable(String),
    dar_req_detail Nullable(String),
    dar_req_finish Nullable(Int64),
    dar_appr_su_id Nullable(Int64),
    dar_appr_su_name Nullable(String),
    dar_appr_timeStr Nullable(String),
    dar_appr_time Nullable(DateTime) default toDateTime(dar_appr_timeStr, \'Asia/Shanghai\'),
    dar_appr_status Nullable(Int64),
    dar_appr_isread Nullable(Int64),
    dar_appr_detail Nullable(String),
    dar_file_size Nullable(String),
    dar_res_status Nullable(Int64),
    dar_res_desc Nullable(String),
    dar_res_create_auth Nullable(Int64),
    dar_apply Nullable(Int64),
    dar_apply_timeStr Nullable(String),
    dar_apply_time Nullable(DateTime) default toDateTime(dar_apply_timeStr, \'Asia/Shanghai\'),
    dar_delete Nullable(Int64),
    dar_appr_flow_id Nullable(Int64),
    dar_all_appr_su Nullable(String),
    dar_cur_appr_su Nullable(String),
    dar_cur_status_detail Nullable(String),
    dar_cur_node_id Nullable(Int64),
    dar_read_info Nullable(String),
    dar_push_result Nullable(Int64),
    dar_push_count Nullable(Int64),
    dar_push_context Nullable(String)
)
    ENGINE = ReplacingMergeTree()
PRIMARY KEY id
ORDER BY (id)
PARTITION BY dar_date
SETTINGS index_granularity = 8192;', 'dar_date', '', '', '解密申请表日志表')$;
INSERT INTO public.gentableconfig (id, tblname, gensql, partitioncol, queryfield, showfield, tabledesc) VALUES (7, 'approval_flow', e'CREATE TABLE IF NOT EXISTS approval_flow
(
    id Int64,
    af_id Int64,
    af_name String
)
    ENGINE = ReplacingMergeTree()
PRIMARY KEY af_id
ORDER BY (af_id)
SETTINGS index_granularity = 8192;', '', '', '', '流程管理表')$;
INSERT INTO public.gentableconfig (id, tblname, gensql, partitioncol, queryfield, showfield, tabledesc) VALUES (8, 'common_approval_flow', e'CREATE TABLE common_approval_flow (
                              id Int64,
                              caf_id String,
                              caf_name String
)engine= ReplacingMergeTree() PRIMARY KEY caf_id;', '', '', '', '流程基础数据')$;
INSERT INTO public.gentableconfig (id, tblname, gensql, partitioncol, queryfield, showfield, tabledesc) VALUES (9, 'auth_request_log', e'CREATE TABLE auth_request_log (
     id Int64,
     ar_request_type Int64,
     ar_history Int64,
     ar_online Int64,
     ar_agt_id Int64,
     ar_usr_id Int64,
     ar_ses_id Int64,
     ar_timeStr String,
     ar_time DateTime default toDateTime(ar_timeStr, \'Asia/Shanghai\'),
     ar_date Int64,
     ar_week Int64,
     ar_hour Int64,
     ar_req_detail String,
     ar_appr_flow_id String,  ar_req_detail_init String,
     ar_all_appr_su String,
     ar_cur_appr_su String,
     ar_appr_timeStr String,
     ar_appr_time DateTime default toDateTime(ar_appr_timeStr, \'Asia/Shanghai\'),
     ar_appr_status Int64,
     ar_appr_isread Int64,
     ar_appr_detail String,
     ar_res_status Int64,
     ar_res_desc String,
     ar_res_create_auth Int64,
     ar_apply Int64,
     ar_apply_timeStr String,
     ar_apply_time DateTime default toDateTime(ar_apply_timeStr, \'Asia/Shanghai\'),
     ar_exec Int64,
     ar_exec_beginStr String,
     ar_exec_begin  Nullable(DateTime) DEFAULT toDateTime(nullIf(ar_exec_beginStr, \'\'), \'Asia/Shanghai\'),
     ar_exec_endStr String,
     ar_exec_end  Nullable(DateTime) DEFAULT toDateTime(nullIf(ar_exec_endStr, \'\'), \'Asia/Shanghai\'),
     ar_auto_exec Int64,
     ar_delete Int64,
     ar_read_info String,
     ar_push_result Int64,
     ar_push_count Int64,
     ar_push_context String,
    extracted_path String MATERIALIZED if(
        position(ar_req_detail, \'<Path>\') > 0 AND position(ar_req_detail, \'</Path>\') > position(ar_req_detail, \'<Path>\'),
        substring(
            ar_req_detail,
            position(ar_req_detail, \'<Path>\') + length(\'<Path>\'),
            position(ar_req_detail, \'</Path>\') - position(ar_req_detail, \'<Path>\') - length(\'<Path>\')
        ),
        \'\'
    ),
    extracted_size String MATERIALIZED if(
        position(ar_req_detail, \'<Size>\') > 0
        AND position(ar_req_detail, \'</Size>\') > position(ar_req_detail, \'<Size>\'),
        substring(
            ar_req_detail,
            position(ar_req_detail, \'<Size>\') + length(\'<Size>\'),
            position(ar_req_detail, \'</Size>\') - position(ar_req_detail, \'<Size>\') - length(\'<Size>\')
        ),
        \'\'
    )
  )
  ENGINE = MergeTree()
  PARTITION BY ar_date
  PRIMARY KEY (ar_date, id)
  ORDER BY (ar_date, id)
', 'ar_date', '', '', '')$;
INSERT INTO public.gentableconfig (id, tblname, gensql, partitioncol, queryfield, showfield, tabledesc) VALUES (10, 'auth_request', e'CREATE TABLE auth_request (
     id Int64,
     ar_request_type Int64,
     ar_history Int64,
     ar_online Int64,
     ar_agt_id Int64,
     ar_usr_id Int64,
     ar_ses_id Int64,
     ar_appr_flow_id String,
     ar_timeStr String,
     ar_time DateTime default toDateTime(ar_timeStr, \'Asia/Shanghai\'),
     ar_date Int64,
     ar_week Int64,
     ar_hour Int64,
     ar_req_detail String,
     ar_req_detail_init String,
     ar_all_appr_su String,
     ar_cur_appr_su String,
     ar_appr_timeStr String,
     ar_appr_time DateTime default toDateTime(ar_appr_timeStr, \'Asia/Shanghai\'),
     ar_appr_status Int64,
     ar_appr_isread Int64,
     ar_appr_detail String,
     ar_res_status Int64,
     ar_res_desc String,
     ar_res_create_auth Int64,
     ar_apply Int64,
     ar_apply_timeStr String,
     ar_apply_time DateTime default toDateTime(ar_apply_timeStr, \'Asia/Shanghai\'),
     ar_exec Int64,
     ar_exec_beginStr String,
     ar_exec_begin  Nullable(DateTime) DEFAULT toDateTime(nullIf(ar_exec_beginStr, \'\'), \'Asia/Shanghai\'),
     ar_exec_endStr String,
     ar_exec_end  Nullable(DateTime) DEFAULT toDateTime(nullIf(ar_exec_endStr, \'\'), \'Asia/Shanghai\'),
     ar_auto_exec Int64,
     ar_delete Int64,
     ar_read_info String,
     ar_push_result Int64,
     ar_push_count Int64,
     ar_push_context String,
    extracted_path String MATERIALIZED if(
        position(ar_req_detail, \'<Path>\') > 0 AND position(ar_req_detail, \'</Path>\') > position(ar_req_detail, \'<Path>\'),
        substring(
            ar_req_detail,
            position(ar_req_detail, \'<Path>\') + length(\'<Path>\'),
            position(ar_req_detail, \'</Path>\') - position(ar_req_detail, \'<Path>\') - length(\'<Path>\')
        ),
        \'\'
    ),
    extracted_size String MATERIALIZED if(
        position(ar_req_detail, \'<Size>\') > 0
        AND position(ar_req_detail, \'</Size>\') > position(ar_req_detail, \'<Size>\'),
        substring(
            ar_req_detail,
            position(ar_req_detail, \'<Size>\') + length(\'<Size>\'),
            position(ar_req_detail, \'</Size>\') - position(ar_req_detail, \'<Size>\') - length(\'<Size>\')
        ),
        \'\'
    )
  )
  ENGINE = MergeTree()
  PARTITION BY ar_date
  PRIMARY KEY (ar_date, id)
  ORDER BY (ar_date, id)
', 'ar_date', '', '', '')$;
INSERT INTO public.gentableconfig (id, tblname, gensql, partitioncol, queryfield, showfield, tabledesc) VALUES (11, 'doc_labels_log', e'CREATE TABLE doc_labels_log (
                              uid String default concat(dlbs_date,lpad(toString(id), 7, \'0\')),
                              id Int64,
                              dlbs_agt_id Int64,
                              dlbs_ses_id Int64,
                              dlbs_usr_id Int64,
                              dlbs_date   Int64,
                              dlbs_timeStr String,
                              dlbs_time DateTime default toDateTime(dlbs_timeStr, \'Asia/Shanghai\'),
                              dlbs_subtype   Int64,
                              dlbs_labels String,
                              dlbs_labels_text String,
                              dlbs_file_name String,
                              dlbs_file_path String,
                              dlbs_docnum String,
                              dlbs_file_size Int64,
                              dlbs_safe_level Int64,
                              dlbs_app_hash String,
                              dlbs_app_title String
)engine= ReplacingMergeTree()
partition by dlbs_date
PRIMARY KEY (dlbs_agt_id,dlbs_file_path,dlbs_time)
ORDER BY (dlbs_agt_id,dlbs_file_path,dlbs_time,dlbs_subtype)', 'dlbs_date', '', 'dlbs_subtype|操作行为', '文档标签日志')$;
INSERT INTO public.gentableconfig (id, tblname, gensql, partitioncol, queryfield, showfield, tabledesc) VALUES (12, 'print_log', e'CREATE TABLE print_log (
   uid String DEFAULT concat(prt_date, lpad(toString(id), 7, \'0\')),
   id Int64,
   prt_agt_id Int64,
   prt_ses_id Int64,
   prt_usr_id Int64,
   prt_timeStr String,
   prt_time DateTime default toDateTime(prt_timeStr, \'Asia/Shanghai\'),
   prt_date Int64,
   prt_week Int64,
   prt_hour Int64,
   prt_type Int64,
   prt_subtype Int64,
   prt_computer String,
   prt_printer String,
   prt_task String,
   prt_paper_type Int64,
   prt_paper_h Int64,
   prt_paper_w Int64,
   prt_orientation Int64,
   prt_page Int64,
   prt_printed Int64,
   prt_app_hash String,
   prt_app_name String,
   prt_app_title String,
   prt_bak_size Int64,
   prt_bak_page Int64,
   prt_bak_file String,
   prt_bak_type Int64,
   prt_text_count Int64
) ENGINE = ReplacingMergeTree
      PARTITION BY prt_date
      PRIMARY KEY (prt_agt_id,prt_usr_id,prt_time,prt_printer,prt_subtype)
      ORDER BY (prt_agt_id,prt_usr_id,prt_time,prt_printer,prt_subtype)
      SETTINGS index_granularity = 8192
', 'prt_date', null, null, '打印日志')$;
INSERT INTO public.gentableconfig (id, tblname, gensql, partitioncol, queryfield, showfield, tabledesc) VALUES (13, 'mail_log', e'CREATE TABLE mail_log (
                          uid String DEFAULT concat(mail_date, lpad(toString(id), 7, \'0\')),
                          id Int64,
                          mail_agt_id Int64,
                          mail_usr_id Int64,
                          mail_timeStr String,
                          mail_time DateTime default toDateTime(mail_timeStr,\'Asia/Shanghai\'),
                          mail_date Int64,
                          mail_week Int64,
                          mail_hour Int64,
                          mail_type Int64,
                          mail_subtype Int64,
                          mail_tool Int64,
                          mail_from String,
                          mail_to String,
                          mail_to_ex String,
                          mail_cc String,
                          mail_cc_ex String,
                          mail_bcc String,
                          mail_bcc_ex String,
                          mail_subject String,
                          mail_plain String,
                          mail_plain_length Int64,
                          mail_html_size Int64,
                          mail_html_type Int64,
                          mail_eml_size Int64,
                          mail_id String,
                          mail_bak_file String,
                          mail_bak_type Int64
) ENGINE = ReplacingMergeTree()
      PARTITION BY mail_date
      PRIMARY KEY (mail_agt_id,mail_usr_id,mail_type, mail_time)
      ORDER BY (mail_agt_id,mail_usr_id,mail_type, mail_time)
      SETTINGS index_granularity = 8192', 'mail_date', null, null, '邮件日志')$;
INSERT INTO public.gentableconfig (id, tblname, gensql, partitioncol, queryfield, showfield, tabledesc) VALUES (14, 'url_report', e'CREATE TABLE url_report (
                            uid String DEFAULT concat(url_date, lpad(toString(id), 7, \'0\')),
                            id Int64,
                            url_agt_id Int64,
                            url_ses_id Int64,
                            url_usr_id Int64,
                            url_date Int64,
                            url_week Int64,
                            url_hour Int64,
                            url_active Int64,
                            url_site String
) ENGINE = ReplacingMergeTree()
      PARTITION BY url_date
      PRIMARY KEY (id,url_agt_id, url_date, url_week, url_hour, url_active, url_site)
      ORDER BY (id,url_agt_id, url_date, url_week, url_hour, url_active, url_site)
', 'url_date', null, null, '上网浏览统计')$;
INSERT INTO public.gentableconfig (id, tblname, gensql, partitioncol, queryfield, showfield, tabledesc) VALUES (15, 'im_session_log', e'CREATE TABLE im_session_log (
                                uid String DEFAULT concat(ims_begin_date, lpad(toString(id), 7, \'0\')),
                                id Int64,
                                ims_agt_id Int64,
                                ims_ses_id Int64,
                                ims_usr_id Int64,
                                ims_begin_timeStr String,
                                ims_begin_time DateTime default toDateTime(ims_begin_timeStr,\'Asia/Shanghai\'),
                                ims_begin_date Int64,
                                ims_begin_week Int64,
                                ims_begin_hour Int64,
                                ims_end_timeStr String,
                                ims_end_time DateTime default toDateTime(ims_end_timeStr,\'Asia/Shanghai\'),
                                ims_end_date Int64,
                                ims_end_week Int64,
                                ims_end_hour Int64,
                                ims_tool Int64,
                                ims_type Int64,
                                ims_local_name String,
                                ims_local_alias String,
                                ims_contact_name String,
                                ims_contact_alias String,
                                ims_number Int64,
                                ims_length Int64
) ENGINE = ReplacingMergeTree()
      PARTITION BY ims_begin_date
      PRIMARY KEY (ims_agt_id,ims_usr_id,ims_tool ,ims_begin_time, ims_local_name)
      ORDER BY (ims_agt_id,ims_usr_id,ims_tool ,ims_begin_time, ims_local_name)', 'ims_begin_date', null, null, '即时通讯日志')$;
INSERT INTO public.gentableconfig (id, tblname, gensql, partitioncol, queryfield, showfield, tabledesc) VALUES (16, 'encrypt_doc_log', e'CREATE TABLE encrypt_doc_log (
                                 uid String DEFAULT concat(edoc_date, lpad(toString(id), 7, \'0\')),
                                 id Int64,
                                 rowguid String,
                                 edoc_agt_id Int64,
                                 edoc_ses_id Int64,
                                 edoc_usr_id Int64,
                                 edoc_timeStr String,
                                 edoc_time DateTime default toDateTime(edoc_timeStr,\'Asia/Shanghai\'),
                                 edoc_date Int64,
                                 edoc_week Int64,
                                 edoc_hour Int64,
                                 edoc_type Int64,
                                 edoc_subtype Int64,
                                 edoc_file_id String,
                                 edoc_file_type Int64,
                                 edoc_file_name String,
                                 edoc_file_path String,
                                 edoc_file_size Int64,
                                 edoc_file_size_high Int64,
                                 edoc_app_name String,
                                 edoc_app_path String,
                                 edoc_app_id Int64,
                                 edoc_app_pid Int64,
                                 edoc_state Int64,
                                 edoc_req_id String,
                                 edoc_old_region String,
                                 edoc_old_level Int64,
                                 edoc_new_region String,
                                 edoc_new_level Int64,
                                 edoc_caution Int64
) ENGINE = ReplacingMergeTree()
      PARTITION BY edoc_date
      PRIMARY KEY (edoc_agt_id, edoc_time, edoc_file_path,edoc_subtype)
      ORDER BY (edoc_agt_id, edoc_time, edoc_file_path,edoc_subtype)', 'edoc_date', null, null, '加密文档操作日志')$;
INSERT INTO public.gentableconfig (id, tblname, gensql, partitioncol, queryfield, showfield, tabledesc) VALUES (17, 'mail_attach', e'CREATE TABLE mail_attach
(
    id Int64,
    mail_id String,
    mail_attach_ordinal Int64,
    mail_attach_name String,
    mail_attach_size Int64,
    mail_attach_nobackup Int64
) ENGINE = ReplacingMergeTree()
      PRIMARY KEY (mail_id)
      ORDER BY (mail_id)', null, null, null, '邮件附件')$;
INSERT INTO public.gentableconfig (id, tblname, gensql, partitioncol, queryfield, showfield, tabledesc) VALUES (18, 'asset_attrib', e'create table asset_attrib
(
    id           Int64,
    ast_cls_id   Int64,
    ast_atb_id   Int64,
    ast_atb_name String,
    ast_atb_type Int64,
    ast_summary  Int64,
    ast_default  Int64
)
    engine = ReplacingMergeTree
        PRIMARY KEY (id, ast_cls_id, ast_atb_id)
        ORDER BY (id, ast_cls_id, ast_atb_id)
        SETTINGS index_granularity = 8192

', '', '', '', '流程基础数据')$;
INSERT INTO public.gentableconfig (id, tblname, gensql, partitioncol, queryfield, showfield, tabledesc) VALUES (19, 'asset_detail', e'create table asset_detail
(
    id          Int64,
    ast_agt_id  Int64,
    ast_ordinal Int64,
    ast_atb_id  Int64,
    ast_str String,
    ast_int Int64,
    ast_time Nullable(DateTime),
    ast_float Float64
)
    engine = ReplacingMergeTree
        PRIMARY KEY (id, ast_agt_id)
        ORDER BY (id, ast_agt_id)
        SETTINGS index_granularity = 8192


', '', '', '', '')$;
INSERT INTO public.gentableconfig (id, tblname, gensql, partitioncol, queryfield, showfield, tabledesc) VALUES (20, 'windows_system_log', e'CREATE TABLE windows_system_log (
        uid String default concat(ws_date,lpad(toString(id), 7, \'0\')),
        id Int64,
        ws_agt_id Int64,
        ws_ses_id Int64,
        ws_usr_id Int64,
        ws_timeStr String,
        ws_time DateTime default toDateTime(ws_timeStr, \'Asia/Shanghai\'),
        ws_date Int64,
        ws_week Int64,
        ws_hour Int64,
        ws_type Int64,
        ws_subtype Int64,
        ws_subtype_desc String,
        ws_writtenStr String,
        ws_written Datetime default toDateTime(ws_writtenStr, \'Asia/Shanghai\'),
        ws_event_id Int64,
        ws_event_type Int64,
        ws_event_level Int64,
        ws_event_keyword Int64,
        ws_log_class String,
        ws_desc String,
        ws_user String,
        ws_machine String,
        ws_src String,
        ws_log_count Int64
)engine= ReplacingMergeTree()
     partition by ws_date
     PRIMARY KEY (ws_agt_id, ws_usr_id, ws_time, ws_subtype, ws_event_type, ws_event_level, ws_event_keyword,uid)
     ORDER BY (ws_agt_id, ws_usr_id, ws_time, ws_subtype, ws_event_type, ws_event_level, ws_event_keyword,uid)', 'ws_date', null, null, 'windows系统日志')$;
INSERT INTO public.gentableconfig (id, tblname, gensql, partitioncol, queryfield, showfield, tabledesc) VALUES (21, 'common_backup_doc_log', e'CREATE TABLE common_backup_doc_log (
        uid String default concat(cbdl_date,lpad(toString(id), 7, \'0\')),
        id Int64,
        cbdl_agt_id Int64,
        cbdl_ses_id Int64,
        cbdl_usr_id Int64,
        cbdl_related_usr_id Int64,
        cbdl_timeStr String,
        cbdl_time DateTime default toDateTime(cbdl_timeStr, \'Asia/Shanghai\'),
        cbdl_date Int64,
        cbdl_week Int64,
        cbdl_hour Int64,
        cbdl_type Int64,
        cbdl_subtype Int64,
        cbdl_beginStr String,
        cbdl_begin DateTime default NULL,
        cbdl_use_time Int64,
        cbdl_file_name String,
        cbdl_file_path String,
        cbdl_modifyStr String,
        cbdl_modify DateTime default NULL,
        cbdl_file_size Int64,
        cbdl_file_crc Int64,
        cbdl_checksum String,
        cbdl_server_ip Int64,
        cbdl_server_name String,
        cbdl_msg_id Int64,
        cbdl_msg_txt String
)engine= ReplacingMergeTree()
     partition by cbdl_date
     PRIMARY KEY (cbdl_agt_id,cbdl_usr_id,cbdl_time,cbdl_subtype,cbdl_file_name)
     ORDER BY (cbdl_agt_id,cbdl_usr_id,cbdl_time,cbdl_subtype,cbdl_file_name)
', 'cbdl_date', null, null, '云备份操作')$;

INSERT INTO public.gentableconfig (id, tblname, gensql, partitioncol, queryfield, showfield, tabledesc) VALUES (22, 'url_lib', e'create table url_lib(
            id Int64,
            url_cls_id Int64,
            url_cls_name String,
            url_desc String,
            url_wc_site String,
            url_all_cls String,
            url_site String
)engine = ReplacingMergeTree
     primary key (id)
     order by (id)
     settings index_granularity = 8192', null, null, null, '网站库')$;
INSERT INTO public.gentableconfig (id, tblname, gensql, partitioncol, queryfield, showfield, tabledesc) VALUES (23, 'url_log', e'CREATE TABLE url_log (
     uid String default concat(url_date,lpad(toString(id), 7, \'0\')),
     id Int64,
     url_agt_id Int64,
     url_ses_id Int64,
     url_usr_id Int64,
     url_timeStr String,
     url_time DateTime default toDateTime(url_timeStr, \'Asia/Shanghai\'),
     url_date Int64,
     url_week Int64,
     url_hour Int64,
     url_type Int64,
     url_subtype Int64,
     url_url String,
     url_site String,
     url_app_hash String,
     url_app_name String,
     url_app_title String
)engine= ReplacingMergeTree()
         partition by url_date
         PRIMARY KEY (uid)
         ORDER BY (uid)', 'url_date', null, null, '网站浏览日志')$;


INSERT INTO public.synctableconfig (id, tblname, fieldsqlms, fieldsqlmy, wheresqlms, wheresqlmy, tbltype, syncdays, cleardays, status, errmessage) VALUES (22, 'view_url_lib', 'id, url_cls_id, url_cls_name, url_desc, url_wc_site, url_all_cls, url_site', 'CAST(id AS SIGNED) id, CAST(url_cls_id AS SIGNED) url_cls_id, url_cls_name, url_desc, url_wc_site, url_all_cls, url_site', null, null, '1', '30', '180', '0', '')$;
INSERT INTO public.synctableconfig (id, tblname, fieldsqlms, fieldsqlmy, wheresqlms, wheresqlmy, tbltype, syncdays, cleardays, status, errmessage) VALUES (23, 'url_log', 'id, url_agt_id, url_ses_id, url_usr_id, CONVERT(varchar, url_time, 120) as url_timeStr, url_date, url_week, url_hour, url_type, url_subtype, url_url, url_site, url_app_hash, url_app_name, url_app_title', 'CAST(id AS SIGNED) id, CAST(url_agt_id AS SIGNED) url_agt_id, CAST(url_ses_id AS SIGNED) url_ses_id, CAST(url_usr_id AS SIGNED) url_usr_id, date_format(url_time,''%Y-%m-%d %H:%i:%s'') as url_timeStr, CAST(url_date AS SIGNED) url_date, CAST(url_week AS SIGNED) url_week, CAST(url_hour AS SIGNED) url_hour, CAST(url_type AS SIGNED) url_type, CAST(url_type AS SIGNED) url_subtype, url_url, url_site, url_app_hash, url_app_name, url_app_title', null, null, '2', '30', '180', '0', '')$;
