CREATE TABLE attendance_weekend_setting (
                                            id SERIAL PRIMARY KEY,
                                            rest_type SMALLINT NOT NULL CHECK (rest_type IN (1, 2)),
                                            single_rest_day SMALLINT,
                                            created_at TIMESTAMP DEFAULT now(),
                                            updated_at TIMESTAMP DEFAULT now(),

                                            CONSTRAINT chk_single_day_validity CHECK (
                                                (rest_type = 1 AND single_rest_day BETWEEN 0 AND 6)
                                                    OR
                                                (rest_type = 2 AND single_rest_day IS NULL)
                                                )
)$;


COMMENT ON TABLE attendance_weekend_setting IS '考勤周末时间设置'$;
COMMENT ON COLUMN attendance_weekend_setting.id IS '主键'$;
COMMENT ON COLUMN attendance_weekend_setting.rest_type IS '周末类型，1-单休；2-双休'$;
COMMENT ON COLUMN attendance_weekend_setting.single_rest_day IS '单休设置那天休息，星期六-6，星期日-0；双休为NULL'$;
COMMENT ON COLUMN attendance_weekend_setting.created_at IS '添加时间'$;
COMMENT ON COLUMN attendance_weekend_setting.updated_at IS '修改时间'$;

INSERT INTO attendance_weekend_setting VALUES (0, 2, NULL)$;


CREATE TABLE attendance_holiday_setting (
                                            id SERIAL PRIMARY KEY,
                                            holiday_type SMALLINT NOT NULL CHECK (holiday_type IN (1, 2)),
                                            holiday_date DATE NOT NULL,
                                            remark VARCHAR(100),

                                            created_at TIMESTAMP DEFAULT now(),
                                            updated_at TIMESTAMP DEFAULT now(),

                                            CONSTRAINT unique_date_type UNIQUE (holiday_type, holiday_date)
)$;

COMMENT ON TABLE attendance_holiday_setting IS '考勤节假日设置'$;
COMMENT ON COLUMN attendance_holiday_setting.holiday_type IS '节日类型，1-工作日；2-休息日'$;
COMMENT ON COLUMN attendance_holiday_setting.holiday_date IS'日期'$;
COMMENT ON COLUMN attendance_holiday_setting.remark IS '备注'$;
COMMENT ON COLUMN attendance_holiday_setting.created_at IS '添加时间'$;
COMMENT ON COLUMN attendance_holiday_setting.updated_at IS '修改时间'$;

CREATE TABLE attendance_time_setting (
                                         id SERIAL PRIMARY KEY,
                                         attendance_type SMALLINT NOT NULL CHECK ( attendance_type IN (0, 1, 2) ),
                                         work_duration_ms int,
                                         work_start TIME,
                                         work_end TIME,
                                         break_start TIME,
                                         break_end TIME,
                                         created_at TIMESTAMP DEFAULT now(),
                                         updated_at TIMESTAMP DEFAULT now()
)$;


COMMENT ON TABLE attendance_time_setting IS '考勤时间设置表'$;
COMMENT ON COLUMN attendance_time_setting.attendance_type IS '考勤类型，0-不考勤；1-固定时间上下班；2-弹性时间上下班'$;
COMMENT ON COLUMN attendance_time_setting.work_duration_ms  IS '弹性时间的最小时长（单位：小时），仅弹性时填写'$;
COMMENT ON COLUMN attendance_time_setting.work_start IS '固定上下班：上班时间'$;
COMMENT ON COLUMN attendance_time_setting.work_end  IS '固定上下班：下班时间'$;
COMMENT ON COLUMN attendance_time_setting.break_start  IS '中途休息开始时间'$;
COMMENT ON COLUMN attendance_time_setting.break_end IS '中途休息结束时间'$;
COMMENT ON COLUMN attendance_time_setting.created_at IS'添加时间'$;
COMMENT ON COLUMN attendance_time_setting.updated_at IS '修改时间'$;

INSERT INTO attendance_time_setting values(0, 1, NULL, '09:00:00', '18:00:00', '12:00:00', '13:30:00')$;

CREATE TABLE attendance_time_group (
                                       id SERIAL PRIMARY KEY,
                                       attendance_setting_id INT NOT NULL REFERENCES attendance_time_setting(id) ON DELETE CASCADE,
                                       group_id INT8 NOT NULL,
                                       group_node varchar(8192),
                                       created_at TIMESTAMP DEFAULT now(),

                                       CONSTRAINT unique_setting_group UNIQUE (attendance_setting_id, group_id),
                                       CONSTRAINT unique_group UNIQUE (group_id)
)$;

COMMENT ON TABLE attendance_time_group IS '考勤时间设置表部门表'$;
COMMENT ON COLUMN attendance_time_group.attendance_setting_id  IS '考勤时间设置表主键id'$;
COMMENT ON COLUMN attendance_time_group.group_id  IS '部门id'$;
COMMENT ON COLUMN attendance_time_group.group_node IS '部门节点,存json'$;
COMMENT ON COLUMN attendance_time_group.created_at IS '添加时间'$;

INSERT INTO attendance_time_group
VALUES (
           0, 0, 0,
           '{"GRP-0":{"id":"GRP-0","label":"整个网络","pid":"GRP--1","type":"1","hightLight":true,"icon":"agent-group"}}'
       )$;

CREATE TABLE attendance_other_setting (
                                          id SERIAL PRIMARY KEY,
                                          cutoff_time VARCHAR(100) NOT NULL DEFAULT '05:00:00',
                                          min_work_duration_ms INT NOT NULL DEFAULT 3600000,
                                          min_overtime_duration_ms INT NOT NULL DEFAULT 1800000,
                                          created_at TIMESTAMP DEFAULT now(),
                                          updated_at TIMESTAMP DEFAULT now()
)$;

COMMENT ON TABLE attendance_other_setting IS '考勤其他设置表'$;
COMMENT ON COLUMN attendance_other_setting.cutoff_time IS '定义工作的结束时间，有可能加班到凌晨的情况'$;
COMMENT ON COLUMN attendance_other_setting.min_work_duration_ms IS '一天最低工作时间'$;
COMMENT ON COLUMN attendance_other_setting.min_overtime_duration_ms IS '最低的加班时长，有效加班时间'$;
COMMENT ON COLUMN attendance_other_setting.created_at IS '添加时间'$;
COMMENT ON COLUMN attendance_other_setting.updated_at IS '修改时间'$;

INSERT INTO attendance_other_setting VALUES (0, '05:00:00', 3600000, 1800000)$;

DELETE FROM public.synctableconfig WHERE id = 22$;
INSERT INTO public.synctableconfig (id, tblname, fieldsqlms, fieldsqlmy, wheresqlms, wheresqlmy, tbltype, syncdays, cleardays, status, errmessage) VALUES (22, 'view_url_lib', 'id, url_cls_id, url_cls_name, url_desc, url_wc_site, url_all_cls, url_site', 'CAST(id AS SIGNED) id, CAST(url_cls_id AS SIGNED) url_cls_id, url_cls_name, url_desc, url_wc_site, url_all_cls, url_site', null, null, '1', '30', '180', '0', '')$;

DELETE FROM public.gentableconfig WHERE id = 22$;
INSERT INTO public.gentableconfig (id, tblname, gensql, partitioncol, queryfield, showfield, tabledesc) VALUES (22, 'url_lib', e'create table url_lib(
            id Int64,
            url_cls_id Int64,
            url_cls_name String,
            url_desc String,
            url_wc_site String,
            url_all_cls String,
            url_site String
)engine = ReplacingMergeTree
     primary key (id)
     order by (id)
     settings index_granularity = 8192', null, null, null, '网站库')$;

DELETE FROM public.synctableconfig WHERE id = 23$;
INSERT INTO public.synctableconfig (id, tblname, fieldsqlms, fieldsqlmy, wheresqlms, wheresqlmy, tbltype, syncdays, cleardays, status, errmessage) VALUES (23, 'url_log', 'id, url_agt_id, url_ses_id, url_usr_id, CONVERT(varchar, url_time, 120) as url_timeStr, url_date, url_week, url_hour, url_type, url_subtype, url_url, url_site, url_app_hash, url_app_name, url_app_title', 'CAST(id AS SIGNED) id, CAST(url_agt_id AS SIGNED) url_agt_id, CAST(url_ses_id AS SIGNED) url_ses_id, CAST(url_usr_id AS SIGNED) url_usr_id, date_format(url_time,''%Y-%m-%d %H:%i:%s'') as url_timeStr, CAST(url_date AS SIGNED) url_date, CAST(url_week AS SIGNED) url_week, CAST(url_hour AS SIGNED) url_hour, CAST(url_type AS SIGNED) url_type, CAST(url_type AS SIGNED) url_subtype, url_url, url_site, url_app_hash, url_app_name, url_app_title', null, null, '2', '30', '180', '0', '')$;

DELETE FROM public.gentableconfig WHERE id = 23$;
INSERT INTO public.gentableconfig (id, tblname, gensql, partitioncol, queryfield, showfield, tabledesc) VALUES (23, 'url_log', e'CREATE TABLE url_log (
     uid String default concat(url_date,lpad(toString(id), 7, \'0\')),
     id Int64,
     url_agt_id Int64,
     url_ses_id Int64,
     url_usr_id Int64,
     url_timeStr String,
     url_time DateTime default toDateTime(url_timeStr, \'Asia/Shanghai\'),
     url_date Int64,
     url_week Int64,
     url_hour Int64,
     url_type Int64,
     url_subtype Int64,
     url_url String,
     url_site String,
     url_app_hash String,
     url_app_name String,
     url_app_title String
)engine= ReplacingMergeTree()
         partition by url_date
         PRIMARY KEY (uid)
         ORDER BY (uid)', 'url_date', null, null, '网站浏览日志')$;
