#!/bin/bash

# 获取当前目录
cd "$(dirname "$0")"
cd ..
dir=$(pwd)

sed -i "s|#{path}|${dir}|g" ${dir}/docker-compose.yml
source ${dir}/shell/version.conf

sh ${dir}/shell/save-path.sh

mkdir /pend

#/bin/sh ${dir}/shell/network.sh
docker rmi bitnami/clickhouse:${clickhouse_v} > ${dir}/log/delete-images.log 2>&1
docker rmi bitnami/postgresql:${pgsql_v}  > ${dir}/log/delete-images.log 2>&1
docker rmi owss:${owss_v}  > ${dir}/log/delete-images.log 2>&1
docker rmi oanalysis:${oanalysis_v}  > ${dir}/log/delete-images.log 2>&1
docker rmi assettool:${assttool_v}  > ${dir}/log/delete-images.log 2>&1


# 加载镜像
docker load -i ${dir}/clickhouse.tar
docker load -i ${dir}/pgsql.tar
docker load -i ${dir}/oanalysis.tar
docker load -i ${dir}/owss.tar
docker load -i ${dir}/assettool.tar
