#!/bin/bash
# 初始化标记变量
starting_shown=false
max_retry=500
count=0

while [ $count -lt $max_retry ]; do
  if pgrep -f "/usr/local/oanalysis/oanalysis" > /dev/null; then
    echo "$(date '+%F %T') - oanalysis 启动成功"
    break
  else
    if [ "$starting_shown" = false ]; then
      echo "$(date '+%F %T') - oanalysis 正在启动..."
      starting_shown=true
    fi
    sleep 2
    count=$((count + 1))
  fi
done

# 如果超过最大尝试次数还未启动
if [ $count -ge $max_retry ]; then
  echo "$(date '+%F %T') - oanalysis 启动失败，已重试 $max_retry 次仍未检测到进程" >&2
  exit 1
fi